/*
 * gabien-app-ppj - Editor/Player for 'PiyoPiyo' music files
 * Written starting in 2015 by contributors (see CREDITS.txt)
 * To the extent possible under law, the author(s) have dedicated all copyright and related and neighboring rights to this software to the public domain worldwide. This software is distributed without any warranty.
 * You should have received a copy of the CC0 Public Domain Dedication along with this software. If not, see <http://creativecommons.org/publicdomain/zero/1.0/>.
 */
package piyopiyoj.games.edittools;

import libpiyo.PiyoPiyoFrame;
import piyopiyoj.games.NotesheetGame;

/**
 * Basis for tools that don't change the 'actual tool'.
 * Created on 24th May, 2022
 */
public abstract class DefaultSemanticsTool implements EditTool {
    @Override
    public void onClick(int frameIndex, int pos, int button, NotesheetGame editor) {
        if (button == 1) {
            PiyoPiyoFrame frame = editor.root.coreFile.ensureFrame(frameIndex, editor.noteDisplay.track);
            frame.hitNotes[pos] = !frame.hitNotes[pos];
            if (!editor.root.playerControls.getPlaying())
                editor.root.playerControls.playNote(editor.noteDisplay.track, pos);
        }
    }

    @Override
    public void onDrag(int frameIndex, int pos, NotesheetGame editor) {

    }
}
