/*
 * gabien-app-ppj - Editor/Player for 'PiyoPiyo' music files
 * Written starting in 2015 by contributors (see CREDITS.txt)
 * To the extent possible under law, the author(s) have dedicated all copyright and related and neighboring rights to this software to the public domain worldwide. This software is distributed without any warranty.
 * You should have received a copy of the CC0 Public Domain Dedication along with this software. If not, see <http://creativecommons.org/publicdomain/zero/1.0/>.
 */
package piyopiyoj.games.edittools;

import gabien.GaBIEn;
import gabien.ui.UIElement;
import gabien.ui.elements.*;
import gabien.ui.layouts.UISplitterLayout;
import piyopiyoj.games.NotesheetGame;

/**
 * Created on 12th November 2025.
 */
public class BeatTapEditTool implements EditTool {
    private double lastBeatTime = -1;
    private double beatDelta = -1;
    private int total = 0, combo = 0;
    private UILabel lastLabel = new UILabel("", 16);

    @Override
    public UIElement toolOpened(final NotesheetGame editor) {
        lastLabel = new UILabel("", 16);
        regenerateText();
        return NoteEditTool.generateBack(UISplitterLayout.produceSideAlignedList(false, true,
                lastLabel
        ), editor);
    }

    @Override
    public void onClick(int frameIndex, int pos, int button, NotesheetGame editor) {
        
    }

    @Override
    public void onDrag(int frameIndex, int pos, NotesheetGame editor) {
    }

    @Override
    public boolean keyboardNotifyShouldSuppress() {
        double now = GaBIEn.getTime();
        if (lastBeatTime < 0) {
            // nothing!
        } else if (beatDelta < 0) {
            beatDelta = now - lastBeatTime;
        } else {
            double expectedNextBeat = lastBeatTime + beatDelta;
            if (Math.abs(expectedNextBeat - now) >= (beatDelta / 4)) {
                // assume we're starting a new sequence
                combo = 0;
                lastBeatTime = now;
                return true;
            }
            beatDelta = ((beatDelta * total) + (now - lastBeatTime)) / (total + 1);
        }
        total++;
        combo++;
        lastBeatTime = now;
        regenerateText();
        return true;
    }

    private void regenerateText() {
        double bpm = 60 / Math.max(beatDelta, 0.01d);
        String line1 = "BPM: " + bpm + " | Beat Time: " + (beatDelta * 1000) + "\n";
        int snappedBPM = (int) Math.round(Math.max(bpm, 1));
        double preSnapBeatTime = 60000 / (double) (snappedBPM * 4);
        int snappedBeatTime = (int) Math.round(preSnapBeatTime);
        // if previous is 4, and new is 2, we need to use scale 2.0
        double scale = preSnapBeatTime / snappedBeatTime;
        double percent = (scale - 1) * 100;
        String line2 = "Adj. BPM: " + snappedBPM + " | Adj. Time: " + snappedBeatTime + " | Percent: " + percent + "\n";
        lastLabel.setText(line1 + line2 + " COMBO x" + combo + " TOTAL x" + total);
    }
}
