/*
 * Part of the PiyoPiyoJ project.
 * (PiyoPiyo Java)
 *
 *        DO WHATEVER YOU WANT TO PUBLIC LICENSE
 *                    Version 2, December 2004
 *
 * Modified by 20kdc <asdd2808@gmail.com> to remove expletives
 * Original copyright (C) 2004 Sam Hocevar <sam@hocevar.net>
 *
 * Everyone is permitted to copy and distribute verbatim or modified
 * copies of this license document, and changing it is allowed as long
 * as the name is changed.
 *
 *            DO WHATEVER YOU WANT TO PUBLIC LICENSE
 *   TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION
 *
 *  0. You just DO WHATEVER YOU WANT TO.
 */

package piyopiyoj.games;

import gabien.wsi.*;

import java.util.LinkedList;

import gabien.ui.*;
import gabien.ui.elements.UILabel;
import gabien.ui.elements.UINumberBox;
import gabien.ui.elements.UITextButton;
import gabien.ui.layouts.UIScrollLayout;
import gabien.ui.layouts.UISplitterLayout;
import piyopiyoj.Game;
import libpiyo.export.*;

/**
 * Because you need a UI to adjust all this stuff.
 */
public class MidiParameterGame extends UIElement.UIProxy {
    public MidiParameterGame(final Game root, final Runnable nx) {
        LinkedList<UIElement> leftP = new LinkedList<>();
        LinkedList<UIElement> rightP = new LinkedList<>();
        for (final MidOut.Parameter param : MidOut.Parameter.values()) {
            final UINumberBox num = new UINumberBox(param.value, 16) {
                @Override
                public void updateContents(double deltaTime, boolean selected, IPeripherals peripherals) {
                    super.updateContents(deltaTime, selected, peripherals);
                    int number = (int) getNumber();
                    if (number >= param.min)
                        if (number <= param.max)
                            param.value = number;
                }
            };
            num.onEdit = new Runnable() {
                @Override
                public void run() {
                    int number = (int) num.getNumber();
                    if (number < param.min)
                        num.setNumber(param.min);
                    if (number > param.max)
                        num.setNumber(param.max);
                    param.value = (int) num.getNumber();
                }
            };
            UIElement uie = new UISplitterLayout(new UILabel(param.text, 16), num, false, 0.75d);
            if (param.left) {
                leftP.add(uie);
            } else {
                rightP.add(uie);
            }
        }
        String txA = "" +
                "PROGRAMS\nNumbers may" +
                " be 1 lower than the number used by the" +
                " synthesizer - the numbers printed here" +
                " are the correct numbers to enter above," +
                " and you should thus subtract 1 from any" +
                " number the synthesizer displays if" +
                " this is the case.\n" +
                "000 AcousticGrand|064 Soprano Sax  \n" +
                "001 Bright Grand |065 Alto Sax     \n" +
                "002 ElectricGrand|066 Tenor Sax    \n" +
                "003 Honky-Tonk   |067 Baritone Sax \n" +
                "004 Electric Pia1|068 Oboe         \n" +
                "005 Electric Pia2|069 English Horn \n" +
                "006 Harpsichord  |070 Bassoon      \n" +
                "007 Clavinet     |071 Clarinet     \n" +
                "008 Celestia     |072 Piccolo      \n" +
                "009 Glockenspiel |073 Flute        \n" +
                "010 Music Box    |074 Recorder     \n" +
                "011 Vibraphone   |075 Pan Flute    \n" +
                "012 Marimba      |076 Blown Bottle \n" +
                "013 Xylophone    |077 Skakuhachi   \n" +
                "014 Tubular Bells|078 Whistle      \n" +
                "015 Dulcimer     |079 Ocarina      \n" +
                "016 Drawbar Organ|080 Lead 1,Square\n" +
                "017 Percussive Or|081 Lead 2,Saw   \n" +
                "018 Rock Organ   |082 Lead 3,Calli.\n" +
                "019 Church Organ |083 Lead 4,Chiff \n" +
                "020 Reed Organ   |084 Lead 5,Chara.\n" +
                "021 Accordion    |085 Lead 6,Voice \n" +
                "022 Harmonica    |086 Lead 7,Fifths\n" +
                "023 Tango Accordi|087 Lead 8,Bass+L\n" +
                "024 Guitar (Nylon|088 Pad 1 New Age\n" +
                "025 Guitar (Steel|089 Pad 2 Warm   \n" +
                "026 Guitar (E,Jaz|090 Pad 3 Polysyn\n" +
                "027 Guitar(E,Clea|091 Pad 4 Choir  \n" +
                "028 Guitar(E,Mute|092 Pad 5 Bowed  \n" +
                "029 Guitar(Overdr|093 Pad 6 Metalli\n" +
                "030 Guitar(Distor|094 Pad 7 Halo   \n" +
                "031 GuitarHarmoni|095 Pad 8 Sweep  \n" +
                "032 Acoustic Bass|096 FX 1         \n" +
                "033 Electric BasF|097 FX 2         \n" +
                "034 Electric BasP|098 FX 3         \n" +
                "035 Fretless Bass|099 FX 4         \n" +
                "036 Slap Bass 1  |100 FX 5         \n" +
                "037 Slap Bass 2  |101 FX 6         \n" +
                "038 Synth Bass 1 |102 FX 7         \n" +
                "039 Synth Bass 2 |103 FX 8         \n" +
                "040 Violin       |104 Sitar        \n" +
                "041 Viola        |105 Banjo        \n" +
                "042 Cello        |106 Shamisen     \n" +
                "043 Contrabass   |107 Koto         \n" +
                "044 Tremolo Strin|108 Kalimba      \n" +
                "045 Pizzicato Str|109 Bagpipe      \n" +
                "046 Orchestral St|110 Fiddle       \n" +
                "047 Timpani      |111 Shanai       \n" +
                "048 String Ensm.1|112 Tinkle Bell  \n" +
                "049 String Ensm.2|113 Agogo        \n" +
                "050 Synth String1|114 Steel Drums  \n" +
                "051 Synth String2|115 Woodblock    \n" +
                "052 Choir Aahs   |116 Taiko Drum   \n" +
                "053 Voice Oohs   |117 Melodic Tom  \n" +
                "054 Synth Voice  |118 Synth Drum   \n" +
                "055 Orchestra Hit|119 Reverse Cymba\n" +
                "056 Trumpet      |120 GuitarFretNo.\n" +
                "057 Trombone     |121 Breath Noise \n" +
                "058 Tuba         |122 Seashore     \n" +
                "059 Trumpet(Muted|123 Twitter User \n" +
                "060 French Horn  |124 TelephoneRing\n" +
                "061 Brass Section|125 Helicopter   \n" +
                "062 Synth Brass 1|126 Applause     \n" +
                "063 Synth Brass 2|127 Gunshot      ";
        String txB = "" +
                "MIDI PERCUSSION NOTE NUMBERS            \n" +
                "The P-channel uses GM percussion.       \n" +
                "This system uses different notes as drum\n" +
                " types and the like.                    \n" +
                "For non-standard synthesizers, please   \n" +
                " read your synthesizer's documentation. \n" +
                "\n" +
                "35 Bass Drum (Acoustic)\n" +
                "36 Bass Drum\n" +
                "37 Side Stick\n" +
                "38 Snare Drum 1\n" +
                "39 Hand Clap\n" +
                "40 Snare Drum 2\n" +
                "41 Low Tom 2\n" +
                "42 Closed Hi-hat\n" +
                "43 Low Tom 1\n" +
                "44 Pedal Hi-hat\n" +
                "45 Mid Tom 2\n" +
                "46 Open Hi-hat\n" +
                "47 Mid Tom 1\n" +
                "48 High Tom 2\n" +
                "49 Crash Cymbal 1\n" +
                "50 High Tom 1\n" +
                "51 Ride Cymbal 1\n" +
                "52 Chinese Cymbal\n" +
                "53 Ride Bell\n" +
                "54 Tambourine\n" +
                "55 Splash Cymbal\n" +
                "56 Cowbell\n" +
                "57 Crash Cymbal 2\n" +
                "58 Vibra Slap\n" +
                "59 Ride Cymbal 2\n" +
                "60 High Bongo\n" +
                "61 Low Bongo\n" +
                "62 Mute High Conga\n" +
                "63 Open High Conga\n" +
                "64 Low Conga\n" +
                "65 High Timbale\n" +
                "66 Low Timbale\n" +
                "67 High Agogo\n" +
                "68 Low Agogo\n" +
                "69 Cabasa\n" +
                "70 Maracas\n" +
                "71 Short Whistle\n" +
                "72 Long Whistle\n" +
                "73 Short Guiro\n" +
                "74 Long Guiro\n" +
                "75 Claves\n" +
                "76 High Wood Block\n" +
                "77 Low Wood Block\n" +
                "78 Mute Cuica\n" +
                "79 Open Cuica\n" +
                "80 Mute Triangle\n" +
                "81 Open Triangle";
        leftP.add(new UILabel(txA, 16));
        rightP.add(new UILabel(txB, 16));
        UIScrollLayout left = new UIScrollLayout(true, 16, leftP.toArray(new UIElement[0]));
        UIScrollLayout right = new UIScrollLayout(true, 16, rightP.toArray(new UIElement[0]));
        UIElement fin = new UITextButton("Confirm Parameters", 16, nx);
        // You know, there *would* be a message here, but...
        proxySetElement(new UISplitterLayout(new UISplitterLayout(left, right, false, 0.5), fin, true, 1d), true);
    }
}
