/*
 * Part of the PiyoPiyoJ project.
 * (PiyoPiyo Java)
 *
 *        DO WHATEVER YOU WANT TO PUBLIC LICENSE
 *                    Version 2, December 2004
 *
 * Modified by 20kdc <asdd2808@gmail.com> to remove expletives
 * Original copyright (C) 2004 Sam Hocevar <sam@hocevar.net>
 *
 * Everyone is permitted to copy and distribute verbatim or modified
 * copies of this license document, and changing it is allowed as long
 * as the name is changed.
 *
 *            DO WHATEVER YOU WANT TO PUBLIC LICENSE
 *   TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION
 *
 *  0. You just DO WHATEVER YOU WANT TO.
 */

package piyopiyoj.games;

import gabien.*;
import gabien.render.*;
import gabien.wsi.*;
import gabien.ui.*;
import gabien.ui.elements.UILabel;
import gabien.ui.elements.UITextButton;
import gabien.ui.layouts.UISplitterLayout;
import gabien.uslx.append.*;
import piyopiyoj.Game;

public class ConfirmGame extends UIElement.UIPanel {
    public UIElement backend;
    public UIElement dialog;
    public IImage img;
    public ConfirmGame(final Game root, UIElement notesheetGame, String s, final Runnable runnable) {
        img = GaBIEn.createImage(new int[] {(int) 0x80000000}, 1, 1);
        backend = notesheetGame;
        // NOTE: Backend never actually gets put in layout, we cheat with it because time reasons
        UIElement ls = new UISplitterLayout(new UITextButton("Accept", 16, new Runnable() {
            @Override
            public void run() {
                runnable.run();
                root.switcher(backend);
            }
        }), new UITextButton("Cancel", 16, new Runnable() {
            @Override
            public void run() {
                root.switcher(backend);
            }
        }), false, 0.5d);
        dialog = new UISplitterLayout(new UILabel(s, 16), ls, true, 1);
        layoutAddElement(dialog);
    }

    @Override
    public void update(double deltaTime, boolean selected, IPeripherals peripherals) {
        backend.update(deltaTime, selected, peripherals);
        super.update(deltaTime, selected, peripherals);
    }

    @Override
    public void renderLayer(IGrDriver igd, UILayer layer) {
        if (layer == UILayer.Clear) {
            backend.renderAllLayers(igd);
            Size sz = getSize();
            igd.blitScaledImage(0, 0, 1, 1, 0, 0, sz.width, sz.height, img);
        }
        super.renderLayer(igd, layer);
    }

    @Override
    protected void layoutRunImpl() {
        Size sz = getSize();
        Size ws = dialog.getWantedSize();
        backend.setForcedBounds(null, new Rect(sz));
        dialog.setForcedBounds(this, new Rect(sz.width / 4, (sz.height - ws.height) / 2, sz.width / 2, ws.height));
    }
}
