/*
 * Part of the PiyoPiyoJ project.
 * (PiyoPiyo Java)
 *
 *        DO WHATEVER YOU WANT TO PUBLIC LICENSE
 *                    Version 2, December 2004
 *
 * Modified by 20kdc <asdd2808@gmail.com> to remove expletives
 * Original copyright (C) 2004 Sam Hocevar <sam@hocevar.net>
 *
 * Everyone is permitted to copy and distribute verbatim or modified
 * copies of this license document, and changing it is allowed as long
 * as the name is changed.
 *
 *            DO WHATEVER YOU WANT TO PUBLIC LICENSE
 *   TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION
 *
 *  0. You just DO WHATEVER YOU WANT TO.
 */

package piyopiyoj;

import gabien.uslx.append.*;
import gabien.ui.UIElement;

/**
 * Part of IPCRESS port - PiyoPiyoJ is heavily reliant on gabien.ui,
 * so it's just plain simpler to wrap the whole thing in a UIGame shell.
 * Created on March 2 2018
 */
public class UIGame extends UIElement.UIPanel {
    private UIElement uie;

    public UIGame() {
        super(640, 480);
    }

    public UIElement getElement() {
        return uie;
    }

    public void changeElement(UIElement n) {
        if (uie != null)
            layoutRemoveElement(uie);
        uie = n;
        if (uie != null) {
            layoutAddElement(uie);
            layoutRecalculateMetrics();
        }
    }

    @Override
    protected void layoutRunImpl() {
        if (uie != null)
            uie.setForcedBounds(this, new Rect(getSize()));
    }

    @Override
    public String toString() {
        return "PiyoPiyoJ";
    }
}
