/*
 * gabien-app-ppj - Editor/Player for 'PiyoPiyo' music files
 * Written starting in 2015 by contributors (see CREDITS.txt)
 * To the extent possible under law, the author(s) have dedicated all copyright and related and neighboring rights to this software to the public domain worldwide. This software is distributed without any warranty.
 * You should have received a copy of the CC0 Public Domain Dedication along with this software. If not, see <http://creativecommons.org/publicdomain/zero/1.0/>.
 */
package libpiyo.export;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class XMCell {
    public byte note, instrument, volume, effect, effectParam;
    public void clear() {
        note = 0;
        instrument = 0;
        volume = 0;
        effect = 0;
        effectParam = 0;
    }
    public boolean isClear() {
        if (note != 0)
            return false;
        if (instrument != 0)
            return false;
        if (volume != 0)
            return false;
        if (effect != 0)
            return false;
        if (effectParam != 0)
            return false;
        return true;
    }

    public static void putPattern(OutputStream os, XMCell[] cells, int channels) throws IOException {
        // note: this may not be completely used!
        ByteBuffer patternBuf = ByteBuffer.allocate(9 + (cells.length * 5));
        patternBuf.order(ByteOrder.LITTLE_ENDIAN);
        // Pattern header
        patternBuf.putInt(9);
        patternBuf.put((byte) 0);
        patternBuf.putShort((short) (cells.length / channels));
        // not yet known!
        patternBuf.putShort((short) 0);
        int packedLen = 0;
        // The meat
        for (int j = 0; j < cells.length; j++) {
            XMCell cell = cells[j];
            if (cell.isClear()) {
                patternBuf.put((byte) 0x80);
                packedLen++;
            } else {
                // the only time we really omit things from a full note is when volume is missing
                // and when that occurs, adding an extra byte to tell us the byte we're removing is missing is zero-sum
                patternBuf.put((byte) cell.note);
                patternBuf.put((byte) cell.instrument);
                patternBuf.put((byte) cell.volume);
                patternBuf.put((byte) cell.effect);
                patternBuf.put((byte) cell.effectParam);
                packedLen += 5;
            }
        }
        // update
        patternBuf.putShort(7, (short) packedLen);
        // Write it out
        os.write(patternBuf.array(), 0, patternBuf.position());
    }
}
