/*
 * Part of the GaBIEn project.
 * (Graphics and Basic Input Engine)
 *
 *        DO WHATEVER YOU WANT TO PUBLIC LICENSE 
 *                    Version 2, December 2004 
 *
 * Modified by 20kdc <asdd2808@gmail.com> to remove expletives
 * Original copyright (C) 2004 Sam Hocevar <sam@hocevar.net> 
 *
 * Everyone is permitted to copy and distribute verbatim or modified 
 * copies of this license document, and changing it is allowed as long 
 * as the name is changed. 
 *
 *            DO WHATEVER YOU WANT TO PUBLIC LICENSE 
 *   TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION 
 *
 *  0. You just DO WHATEVER YOU WANT TO.
 */
package libpiyo;

import gabien.GaBIEn;
import gabien.media.audio.AudioIOCRSet;
import gabien.media.audio.AudioIOFormat;
import gabien.media.audio.AudioIOSample;
import gabien.media.audio.AudioIOSource;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class PiyoPiyoPlayingSample {

    // Sample indexes
    public static int[] drumTable = new int[] {0, 1, 4, -1, 2, 3, 5, -1, -1,
            -1, -1, -1};

    public static short[][] samples = new short[6][];

    public static void ensureAllSamplesLoaded() throws IOException {
        // Note: It may or may not be a good idea to pack this with the
        // distribution,
        // so I'm keeping it out of the source tree
        InputStream is = GaBIEn.getInFile("piyoDrums.bin");
        if (is == null)
            throw new IOException("Couldn't open piyoDrums.bin");
        DataInputStream dis = new DataInputStream(is);
        for (int drumSample = 0; drumSample < 6; drumSample++) {
            short[] sample = new short[dis.readInt() / 2];
            for (int i = 0; i < sample.length; i++) {
                int l = dis.read();
                sample[i] = (short) (dis.read() << 8);
                sample[i] |= l;
            }
            samples[drumSample] = sample;
        }
        is.close();
    }

    public static short[] getSample(int pos, int sampleRateMul) {
        int drumSample = drumTable[pos / 2];
        if (drumSample == -1)
            return new short[1];
        if (samples[drumSample] == null)
            return new short[1];
        final short[] origSample = samples[drumSample];
        if (sampleRateMul != 1) {
            AudioIOSample smp;
            try {
                smp = new AudioIOSample(new AudioIOSource.SourceS16(new AudioIOCRSet(1, 22050)) {
                    int idx = 0;

                    @Override
                    public int frameCount() {
                        return origSample.length;
                    }
                    
                    @Override
                    public void nextFrames(short[] buffer, int at, int frames) {
                        for (int i = 0; i < frames; i++) {
                            buffer[at++] = origSample[idx++];
                        }
                    }
                }, AudioIOFormat.F_S16);
            } catch (IOException e) {
                // No actual IO happens here.
                throw new RuntimeException(e);
            }
            smp = smp.resample(new AudioIOCRSet(1, 22050 * sampleRateMul), false);
            short[] newSample = new short[smp.length];
            int[] tmp = new int[1];
            for (int i = 0; i < newSample.length; i++) {
                smp.getS32(i, tmp);
                newSample[i] = (short) (tmp[0] >> 16);
            }
            return newSample;
        }
        return origSample;
    }
}
