/*
 * Part of the GaBIEn project.
 * (Graphics and Basic Input Engine)
 *
 *        DO WHATEVER YOU WANT TO PUBLIC LICENSE 
 *                    Version 2, December 2004 
 *
 * Modified by 20kdc <asdd2808@gmail.com> to remove expletives
 * Original copyright (C) 2004 Sam Hocevar <sam@hocevar.net> 
 *
 * Everyone is permitted to copy and distribute verbatim or modified 
 * copies of this license document, and changing it is allowed as long 
 * as the name is changed. 
 *
 *            DO WHATEVER YOU WANT TO PUBLIC LICENSE 
 *   TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION 
 *
 *  0. You just DO WHATEVER YOU WANT TO.
 */
package libpiyo;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class PiyoPiyoFrame {
    public boolean[] hitNotes = new boolean[24];
    public int panValue;

    public PiyoPiyoFrame() {

    }

    public PiyoPiyoFrame(PiyoPiyoFrame other) {
        for (int i = 0; i < hitNotes.length; i++)
            hitNotes[i] = other.hitNotes[i];
        panValue = other.panValue;
    }

    public void read(InputStream is) throws IOException {
        decodeBitfield(PiyoPiyoFile.read8(is), 0);
        decodeBitfield(PiyoPiyoFile.read8(is), 8);
        decodeBitfield(PiyoPiyoFile.read8(is), 16);
        panValue = PiyoPiyoFile.read8(is);
    }

    private void decodeBitfield(int read8, int i) {
        int v = 1;
        for (int b = 0; b < 8; b++) {
            hitNotes[b + i] = (read8 & v) != 0;
            v = v << 1;
        }
    }

    private int encodeBitfield(int i) {
        int v = 1;
        int r = 0;
        for (int b = 0; b < 8; b++) {
            if (hitNotes[b + i])
                r |= v;
            v = v << 1;
        }
        return r;
    }

    public void write(OutputStream os) throws IOException {
        os.write(encodeBitfield(0));
        os.write(encodeBitfield(8));
        os.write(encodeBitfield(16));
        os.write(panValue);
    }

    public boolean isEmpty() {
        for (int b = 0; b < hitNotes.length; b++)
            if (hitNotes[b])
                return false;
        return panValue == 0;
    }

    public void merge(PiyoPiyoFrame musicFrame) {
        for (int b = 0; b < 24; b++)
            hitNotes[b] |= musicFrame.hitNotes[b];
        if (musicFrame.panValue != 0)
            panValue = musicFrame.panValue;
    }
}
