/*
 * Decompiled with CFR 0.152.
 */
package piyopiyoj.games.ui;

import gabien.ui.UIElement;
import gabien.ui.elements.UILabel;
import gabien.ui.elements.UINumberBox;
import gabien.uslx.append.Rect;
import gabien.uslx.append.Size;
import libpiyo.PiyoPiyoWaveTrack;
import piyopiyoj.Game;
import piyopiyoj.games.ui.UIGraphEditor;

public class UIWaveTrackHeaderEditor
extends UIElement.UIPanel {
    public final PiyoPiyoWaveTrack theTrack;
    public UIGraphEditor waveForm;
    public UIGraphEditor envelope;
    public UILabel volumeLabel = new UILabel("Track Volume:", 16);
    public UILabel lengthLabel = new UILabel("Envelope Len:", 16);
    public UILabel octaveLabel = new UILabel("Track Octave:", 16);
    public UINumberBox volumeBox = new UINumberBox(0L, 16);
    public UINumberBox lengthBox = new UINumberBox(0L, 16);
    public UINumberBox octaveBox = new UINumberBox(0L, 16);

    public UIWaveTrackHeaderEditor(final Game root, PiyoPiyoWaveTrack track) {
        super(640, 384);
        this.waveForm = new UIGraphEditor(root, track.waveForm, true);
        this.envelope = new UIGraphEditor(root, track.envelope, false);
        this.theTrack = track;
        this.layoutAddElement(this.waveForm);
        this.layoutAddElement(this.envelope);
        this.layoutAddElement(this.volumeLabel);
        this.volumeBox.onEdit = new Runnable(){

            @Override
            public void run() {
                root.startModifications("WaveTrack Volume");
                UIWaveTrackHeaderEditor.this.theTrack.volume = (int)UIWaveTrackHeaderEditor.this.volumeBox.getNumber();
                root.endModifications();
                root.playerControls.regenWaveforms();
            }
        };
        this.layoutAddElement(this.volumeBox);
        this.layoutAddElement(this.lengthLabel);
        this.lengthBox.onEdit = new Runnable(){

            @Override
            public void run() {
                root.startModifications("WaveTrack Envelope Length");
                UIWaveTrackHeaderEditor.this.theTrack.length = (int)UIWaveTrackHeaderEditor.this.lengthBox.getNumber();
                root.endModifications();
                root.playerControls.regenWaveforms();
            }
        };
        this.layoutAddElement(this.lengthBox);
        this.layoutAddElement(this.octaveLabel);
        this.octaveBox.onEdit = new Runnable(){

            @Override
            public void run() {
                root.startModifications("WaveTrack Octave");
                UIWaveTrackHeaderEditor.this.theTrack.octave = (int)UIWaveTrackHeaderEditor.this.octaveBox.getNumber();
                root.endModifications();
                root.playerControls.regenWaveforms();
            }
        };
        this.layoutAddElement(this.octaveBox);
    }

    @Override
    protected void layoutRunImpl() {
        Size elementBounds = this.getSize();
        this.waveForm.setForcedBounds(this, new Rect(0, 0, elementBounds.width, 256));
        this.envelope.setForcedBounds(this, new Rect(0, 257, 128, 127));
        this.volumeLabel.setForcedBounds(this, new Rect(129, 257, 220, 18));
        this.lengthLabel.setForcedBounds(this, new Rect(129, 275, 220, 18));
        this.octaveLabel.setForcedBounds(this, new Rect(129, 293, 220, 18));
        this.volumeBox.setForcedBounds(this, new Rect(349, 257, elementBounds.width - 350, 18));
        this.lengthBox.setForcedBounds(this, new Rect(349, 275, elementBounds.width - 350, 18));
        this.octaveBox.setForcedBounds(this, new Rect(349, 293, elementBounds.width - 350, 18));
    }

    public void refresh() {
        this.volumeBox.setNumber(this.theTrack.volume);
        this.lengthBox.setNumber(this.theTrack.length);
        this.octaveBox.setNumber(this.theTrack.octave);
    }
}

