/*
 * Decompiled with CFR 0.152.
 */
package piyopiyoj.games.ui;

import gabien.GaBIEn;
import gabien.media.audio.AudioIOCRSet;
import gabien.media.audio.AudioIOFormat;
import gabien.media.audio.AudioIOSample;
import gabien.media.audio.AudioIOSource;
import gabien.media.audio.PCMConversions;
import gabien.media.audio.fileio.ReadAnySupportedAudioSource;
import gabien.ui.UIElement;
import gabien.ui.elements.UILabel;
import gabien.ui.elements.UITextButton;
import gabien.ui.layouts.UISplitterLayout;
import gabien.wsi.IPeripherals;
import piyopiyoj.PlayerControls;

public class UIPlayerControls
extends UIElement.UIProxy {
    public final PlayerControls corePlayer;
    private UITextButton refTrack = (UITextButton)new UITextButton("Ref", 16, new Runnable(){

        @Override
        public void run() {
            UIPlayerControls.this.corePlayer.useRefTrack = ((UIPlayerControls)UIPlayerControls.this).refTrack.state;
        }
    }).togglable(false);
    private UITextButton refSetTrack = new UITextButton("(Set)", 16, new Runnable(){

        @Override
        public void run() {
            GaBIEn.startFileBrowser("Load Reference Track...", false, "", s -> {
                try {
                    AudioIOSource src = ReadAnySupportedAudioSource.open(GaBIEn.getInFile(s), true);
                    AudioIOSample smp = new AudioIOSample(src, AudioIOFormat.F_F32);
                    AudioIOSample rsmp = smp.resample(new AudioIOCRSet(2, 22050), false);
                    int[] tmp = new int[2];
                    short[] res = new short[rsmp.length * 2];
                    for (int i = 0; i < res.length; i += 2) {
                        rsmp.getS32(i / 2, tmp);
                        PCMConversions.pcmS32ToS16(tmp, 0, res, i, 2);
                    }
                    UIPlayerControls.this.corePlayer.refTrack = res;
                    UIPlayerControls.this.refSetTrack.setText("(Ok!)");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    UIPlayerControls.this.refSetTrack.setText("(Err)");
                }
            });
        }
    });
    private UITextButton play = (UITextButton)new UITextButton(">", 16, new Runnable(){

        @Override
        public void run() {
            ((UIPlayerControls)UIPlayerControls.this).playReverse.state = false;
            UIPlayerControls.this.corePlayer.setPlaying(((UIPlayerControls)UIPlayerControls.this).play.state);
            UIPlayerControls.this.corePlayer.reverse = false;
        }
    }).togglable(false);
    private UITextButton playReverse = (UITextButton)new UITextButton("<", 16, new Runnable(){

        @Override
        public void run() {
            ((UIPlayerControls)UIPlayerControls.this).play.state = false;
            UIPlayerControls.this.corePlayer.setPlaying(((UIPlayerControls)UIPlayerControls.this).playReverse.state);
            UIPlayerControls.this.corePlayer.reverse = true;
        }
    }).togglable(false);
    private UITextButton halfSpeed = (UITextButton)new UITextButton("/", 16, new Runnable(){

        @Override
        public void run() {
            UIPlayerControls.this.corePlayer.halfSpeed = ((UIPlayerControls)UIPlayerControls.this).halfSpeed.state;
        }
    }).togglable(false);
    private UITextButton toStart = new UITextButton("<<", 16, new Runnable(){

        @Override
        public void run() {
            UIPlayerControls.this.corePlayer.playerLock.lock();
            UIPlayerControls.this.corePlayer.setCurrentFrame(0);
            UIPlayerControls.this.corePlayer.playerLock.unlock();
        }
    });
    private UITextButton toEnd = new UITextButton(">>", 16, new Runnable(){

        @Override
        public void run() {
            UIPlayerControls.this.corePlayer.playerLock.lock();
            UIPlayerControls.this.corePlayer.setCurrentFrame(UIPlayerControls.this.corePlayer.coreFile.loopEnd);
            UIPlayerControls.this.corePlayer.playerLock.unlock();
        }
    });
    private UITextButton loop = (UITextButton)new UITextButton("Loop", 16, new Runnable(){

        @Override
        public void run() {
            UIPlayerControls.this.corePlayer.setHandleLoop(((UIPlayerControls)UIPlayerControls.this).loop.state);
        }
    }).togglable(false);
    private UILabel songDetails = new UILabel("insert details", 16);

    public UIPlayerControls(PlayerControls myPlayer) {
        this.corePlayer = myPlayer;
        boolean playing = this.corePlayer.getPlaying();
        this.play.state = playing && !this.corePlayer.reverse;
        this.playReverse.state = playing && this.corePlayer.reverse;
        this.halfSpeed.state = this.corePlayer.halfSpeed;
        this.loop.state = this.corePlayer.getHandleLoop();
        this.proxySetElement(UISplitterLayout.produceSideAlignedList(true, false, this.songDetails, this.refTrack, this.refSetTrack, this.loop, this.toStart, this.playReverse, this.halfSpeed, this.play, this.toEnd), true);
    }

    @Override
    public void update(double deltaTime, boolean selected, IPeripherals peripherals) {
        double frameInterp = this.corePlayer.getFrameInterpolatedPrecise();
        int currentFrame = (int)Math.floor(frameInterp);
        double time = this.convertTime(0, frameInterp * this.corePlayer.coreFile.beatTime());
        double timeEnd = this.convertTime(this.corePlayer.coreFile.loopEnd, 0.0);
        this.songDetails.setText(currentFrame + "/" + this.corePlayer.coreFile.getFrameCount() + " (" + time + "s/" + timeEnd + "s)");
        super.update(deltaTime, selected, peripherals);
    }

    private double convertTime(int frames, double offset) {
        double time = (double)frames * this.corePlayer.coreFile.beatTime() + offset;
        time *= 10.0;
        time = (int)time;
        return time /= 10.0;
    }
}

