/*
 * Decompiled with CFR 0.152.
 */
package piyopiyoj.games.ui;

import gabien.GaBIEn;
import gabien.render.IGrDriver;
import gabien.render.IImage;
import gabien.text.RenderedTextChunk;
import gabien.text.SimpleImageGridFont;
import gabien.text.TextTools;
import gabien.ui.IPointerReceiver;
import gabien.ui.OldMouseEmulator;
import gabien.ui.UIElement;
import gabien.ui.UILayer;
import gabien.uslx.append.Size;
import gabien.wsi.IPeripherals;
import gabien.wsi.IPointer;
import java.util.function.Consumer;
import libpiyo.PiyoPiyoFile;
import libpiyo.PiyoPiyoFrame;

public class UINotesDisplay
extends UIElement
implements OldMouseEmulator.IOldMouseReceiver {
    public final PiyoPiyoFile file;
    public final Consumer<Boolean> scrollWheel;
    public static final int fingerLen = 24;
    public static final int tileSize = 12;
    public int xOffset;
    public int track;
    public int selectedStart = 1;
    public int selectedEnd = 0;
    public OldMouseEmulator emulation = new OldMouseEmulator(this);
    public NoteClickCallback toolCallback = null;
    public boolean[] fingerInvert = new boolean[24];
    public RenderedTextChunk[] fingerTextA = new RenderedTextChunk[24];
    public RenderedTextChunk[] fingerTextB = new RenderedTextChunk[24];
    public RenderedTextChunk[] fingerTextAI = new RenderedTextChunk[24];
    public RenderedTextChunk[] fingerTextBI = new RenderedTextChunk[24];

    public UINotesDisplay(PiyoPiyoFile f, Consumer<Boolean> sw) {
        super(640, 384);
        this.file = f;
        this.scrollWheel = sw;
        String[] keyA = new String[]{"B", "A#", "A", "G#", "G", "F#", "F", "E", "D#", "D", "C#", "C", "B", "A#", "A", "G#", "G", "F#", "F", "E", "D#", "D", "C#", "C"};
        String[] keyB = new String[]{"", "", "", "", "", "", "", "", "", "", "Cs", "Cs!", "Cl", "Cl!", "HH", "HH!", "", "", "X3", "X3!", "X2", "X2!", "X1", "X1!"};
        SimpleImageGridFont f8 = GaBIEn.engineFonts.f8;
        for (int i = 0; i < keyA.length; ++i) {
            this.fingerTextA[i] = TextTools.renderString(keyA[i], f8, false);
            this.fingerTextB[i] = TextTools.renderString(keyB[i], f8, false);
            this.fingerTextAI[i] = TextTools.renderString(keyA[i], f8, true);
            this.fingerTextBI[i] = TextTools.renderString(keyB[i], f8, true);
        }
    }

    @Override
    public void update(double deltaTime, boolean selected, IPeripherals peripherals) {
        Size elementBounds = this.getSize();
        int requiredSize = this.xOffset + elementBounds.width / 12;
        if (this.file.getFrameCount() < requiredSize) {
            this.file.resize(requiredSize + 64);
        }
    }

    @Override
    public void renderLayer(IGrDriver igd, UILayer layer) {
        if (layer != UILayer.Content) {
            return;
        }
        igd.clearAll(0, 0, 0);
        IImage ui = GaBIEn.getImageCKEx("ui.png", false, true, 0, 0, 0);
        Size elementBounds = this.getSize();
        boolean[] sharp = new boolean[]{false, true, false, true, false, true, false, false, true, false, true, false, false, true, false, true, false, true, false, false, true, false, true, false};
        for (int py = 0; py < elementBounds.height / 12; ++py) {
            if (py >= this.fingerInvert.length) continue;
            igd.blitImage(sharp[py] ? 24.0f : 0.0f, 12.0f, 24.0f, 12.0f, 0.0f, py * 12, ui);
            RenderedTextChunk src = this.track != 3 ? (this.fingerInvert[this.fingerInvert.length - (py + 1)] ? this.fingerTextAI[py] : this.fingerTextA[py]) : (this.fingerInvert[this.fingerInvert.length - (py + 1)] ? this.fingerTextBI[py] : this.fingerTextB[py]);
            src.renderRoot(igd, 1, 2 + py * 12 + src.highestAscent);
        }
        boolean firstColumn = true;
        for (int px = 0; px < (elementBounds.width - 24) / 12; ++px) {
            if (px + this.xOffset < 0) continue;
            PiyoPiyoFrame frameA = this.file.getFrameOrNull(px + this.xOffset, 0);
            PiyoPiyoFrame frameB = this.file.getFrameOrNull(px + this.xOffset, 1);
            PiyoPiyoFrame frameC = this.file.getFrameOrNull(px + this.xOffset, 2);
            PiyoPiyoFrame frameD = this.file.getFrameOrNull(px + this.xOffset, 3);
            PiyoPiyoFrame frameCurrent = this.file.getFrameOrNull(px + this.xOffset, this.track);
            if (frameA == null || frameB == null || frameC == null || frameD == null || frameCurrent == null) continue;
            SimpleImageGridFont f8 = GaBIEn.engineFonts.f8;
            for (int py = 0; py < elementBounds.height / 12; ++py) {
                if (py == 24) {
                    boolean flash;
                    boolean aBar = (px + this.xOffset & 0xF) == 0;
                    boolean bl = flash = (px + this.xOffset >> 2 & 1) == 0;
                    if (!flash) {
                        igd.blitImage(0.0f, 0.0f, 12.0f, 12.0f, 24 + px * 12, py * 12, ui);
                    }
                    if (!aBar) continue;
                    String tx = Integer.toString(px + this.xOffset >> 4);
                    int markerX = 24 + px * 12;
                    int markerY = py * 12;
                    f8.drawLine(igd, markerX, markerY += f8.getLineHeight(), tx, 255, 255, 255, 255);
                    continue;
                }
                if (py >= 25) {
                    if (py >= 32) continue;
                    int idx = 5;
                    int idxY = 0;
                    if (firstColumn) {
                        if (py == 25) {
                            idx = 6;
                            idxY = 1;
                        }
                        if (py == 31) {
                            idx = 5;
                            idxY = 1;
                        }
                    }
                    igd.blitImage(12 * idx, 12 * idxY, 12.0f, 12.0f, 24 + px * 12, py * 12, ui);
                    if (frameCurrent.panValue != py - 24) continue;
                    igd.blitImage(12.0f, 0.0f, 12.0f, 12.0f, 24 + px * 12, py * 12, ui);
                    continue;
                }
                boolean flash = sharp[py];
                igd.blitImage(flash ? 72.0f : 0.0f, 0.0f, 12.0f, 12.0f, 24 + px * 12, py * 12, ui);
                if (frameCurrent.hitNotes[23 - py]) {
                    igd.blitImage(12.0f, 0.0f, 12.0f, 12.0f, 24 + px * 12, py * 12, ui);
                } else if (frameA.hitNotes[23 - py] || frameB.hitNotes[23 - py] || frameC.hitNotes[23 - py] || frameD.hitNotes[23 - py]) {
                    igd.blitImage(48.0f, 12.0f, 12.0f, 12.0f, 24 + px * 12, py * 12, ui);
                }
                if (this.file.loopEnd == px + this.xOffset) {
                    igd.blitImage(24.0f, 0.0f, 12.0f, 12.0f, 24 + px * 12, py * 12, ui);
                }
                if (this.file.loopStart == px + this.xOffset) {
                    igd.blitImage(36.0f, 0.0f, 12.0f, 12.0f, 24 + px * 12, py * 12, ui);
                }
                if (px + this.xOffset < this.selectedStart || px + this.xOffset > this.selectedEnd) continue;
                igd.blitImage(48.0f, 0.0f, 12.0f, 12.0f, 24 + px * 12, py * 12, ui);
            }
            firstColumn = false;
        }
    }

    @Override
    public void handleClick(int x, int y, int button) {
        if (x < 24) {
            if (y / 12 >= 24) {
                return;
            }
            this.toolCallback.onFingerClick(23 - y / 12, button);
            return;
        }
        int ox = (x - 24) / 12 + this.xOffset;
        if (ox < 0) {
            return;
        }
        int yds = y / 12;
        if (yds == 24) {
            return;
        }
        if (yds >= 25) {
            if (yds < 32) {
                this.adjustPan(ox, yds);
            }
            return;
        }
        if (this.toolCallback != null) {
            this.toolCallback.onClick(ox, 23 - yds, button);
        }
    }

    @Override
    public void handleDrag(int x, int y) {
        if (x < 24) {
            return;
        }
        int ox = (x - 24) / 12 + this.xOffset;
        if (ox < 0) {
            return;
        }
        int yds = y / 12;
        if (yds >= 24) {
            return;
        }
        if (this.toolCallback != null) {
            this.toolCallback.onDrag(ox, 23 - yds);
        }
    }

    @Override
    public void handleRelease(int x, int y) {
        if (this.toolCallback != null) {
            this.toolCallback.onRelease();
        }
    }

    @Override
    public void handleMousewheel(int x, int y, boolean north) {
        this.scrollWheel.accept(north);
    }

    @Override
    public IPointerReceiver handleNewPointer(IPointer state) {
        return this.emulation;
    }

    private void adjustPan(int ox, int i) {
        if (this.toolCallback != null) {
            this.toolCallback.prePC();
        }
        PiyoPiyoFrame ppf = this.file.getFrameOrNull(ox, this.track);
        ppf.panValue = ppf.panValue == i - 24 ? 0 : i - 24;
        if (this.toolCallback != null) {
            this.toolCallback.postPC();
        }
    }

    public static interface NoteClickCallback {
        public void onClick(int var1, int var2, int var3);

        public void onDrag(int var1, int var2);

        public void onRelease();

        public void onFingerClick(int var1, int var2);

        public void prePC();

        public void postPC();
    }
}

