/*
 * Decompiled with CFR 0.152.
 */
package piyopiyoj.games.ui;

import gabien.GaBIEn;
import gabien.render.IGrDriver;
import gabien.render.IImage;
import gabien.ui.IPointerReceiver;
import gabien.ui.UIElement;
import gabien.ui.UILayer;
import gabien.uslx.append.Size;
import gabien.wsi.IPeripherals;
import gabien.wsi.IPointer;
import java.util.WeakHashMap;
import piyopiyoj.Game;

public class UIGraphEditor
extends UIElement
implements IPointerReceiver {
    public final int[] targetArray;
    public final boolean signed;
    public int leftOffset = 0;
    public WeakHashMap<IPointer, Integer> lastPos = new WeakHashMap();
    public final Game root;
    public int working = 0;

    public UIGraphEditor(Game r, int[] coreArray, boolean s) {
        super(coreArray.length * 2, 256);
        this.root = r;
        this.targetArray = coreArray;
        this.signed = s;
    }

    @Override
    public void update(double deltaTime, boolean selected, IPeripherals peripherals) {
    }

    @Override
    public void renderLayer(IGrDriver igd, UILayer layer) {
        if (layer != UILayer.Content) {
            return;
        }
        IImage im = GaBIEn.getImageEx("graph.png", false, true);
        Size elementBounds = this.getSize();
        int range = elementBounds.height;
        int s1 = this.signed ? 255 : 127;
        igd.blitScaledImage(2.0f, 2.0f, 2.0f, this.signed ? 4.0f : 2.0f, 0.0f, 0.0f, elementBounds.width, elementBounds.height, im);
        igd.blitScaledImage(0.0f, 2.0f, 2.0f, this.signed ? 4.0f : 2.0f, this.leftOffset, 0.0f, this.targetArray.length * 2, elementBounds.height, im);
        for (int i = -((this.leftOffset + 1) / 2); i < this.targetArray.length + (this.leftOffset + 3) / 2; ++i) {
            int sp;
            for (sp = i; sp < 0; sp += this.targetArray.length) {
            }
            int ei = this.targetArray[sp % this.targetArray.length];
            if (this.signed) {
                ei ^= 0x80;
            }
            ei = s1 - ei;
            int srcX = 0;
            if (i < 0) {
                srcX = 2;
            }
            if (i >= this.targetArray.length) {
                srcX = 2;
            }
            igd.blitImage(srcX, 0.0f, 2.0f, 2.0f, i * 2 + this.leftOffset, ei * range / s1 - 1, im);
        }
    }

    @Override
    public IPointerReceiver handleNewPointer(IPointer state) {
        return this;
    }

    @Override
    public void handlePointerBegin(IPointer state) {
        ++this.working;
        if (this.working == 1) {
            this.root.startModifications("GraphEditor");
        }
        this.handlePointerUpdate(state);
    }

    @Override
    public void handlePointerEnd(IPointer state) {
        this.handlePointerUpdate(state);
        this.lastPos.remove(state);
        --this.working;
        if (this.working == 0) {
            this.root.endModifications();
            this.root.playerControls.regenWaveforms();
        }
        if (this.working < 0) {
            throw new RuntimeException("Pointer count < 0 - UI framework malfunction");
        }
    }

    @Override
    public void handlePointerUpdate(IPointer state) {
        if (state.getType() == IPointer.PointerType.Generic) {
            int v = (state.getX() - this.leftOffset) / 2;
            int s1 = this.signed ? 255 : 127;
            double position = (double)(state.getY() + 1) / ((double)this.getSize().height - 1.0);
            int ei = (int)(position *= (double)s1);
            if (ei > s1) {
                ei = s1;
            }
            if (ei < 0) {
                ei = 0;
            }
            ei = s1 - ei;
            if (this.signed) {
                ei ^= 0x80;
            }
            this.mainPointerCore(v, ei, state);
        }
    }

    private void mainPointerCore(int v, int ei, IPointer state) {
        int i = v;
        Integer i2 = this.lastPos.get(state);
        if (i2 != null) {
            i = i2;
        }
        for (int j = Math.min(i, v); j <= Math.max(i, v); ++j) {
            int j2;
            if (this.signed) {
                for (j2 = j; j2 < 0; j2 += this.targetArray.length) {
                }
                j2 %= this.targetArray.length;
            } else {
                if (j2 < 0) {
                    j2 = 0;
                }
                if (j2 >= this.targetArray.length) {
                    j2 = this.targetArray.length - 1;
                }
            }
            this.targetArray[j2] = ei;
        }
        this.lastPos.put(state, v);
    }

    @Override
    protected void layoutRunImpl() {
        this.leftOffset = (this.getSize().width - this.targetArray.length * 2) / 2;
    }
}

