/*
 * Decompiled with CFR 0.152.
 */
package piyopiyoj.games.edittools;

import gabien.ui.UIElement;
import libpiyo.PiyoPiyoFrame;
import piyopiyoj.games.NotesheetGame;
import piyopiyoj.games.edittools.EditTool;
import piyopiyoj.games.edittools.NoteEditTool;

public class PasteEditTool
implements EditTool {
    public final boolean allTracks;

    public PasteEditTool(boolean at) {
        this.allTracks = at;
    }

    @Override
    public UIElement toolOpened(NotesheetGame editor) {
        return NoteEditTool.generateTmp(this.allTracks ? "Paste All Tracks:\n Click at paste location." : "Paste Track Tool:\n Click at paste location.", editor);
    }

    @Override
    public void onClick(int frameIndex, int pos, int button, NotesheetGame editor) {
        if (button == 1) {
            if (!this.allTracks) {
                this.pasteForTrack(frameIndex, editor.noteDisplay.track, editor);
            } else {
                for (int i = 0; i < 4; ++i) {
                    this.pasteForTrack(frameIndex, i, editor);
                }
            }
            editor.noteDisplay.selectedEnd += frameIndex - editor.noteDisplay.selectedStart;
            editor.noteDisplay.selectedStart = frameIndex;
        }
    }

    private void pasteForTrack(int frameIndex, int track, NotesheetGame editor) {
        PiyoPiyoFrame frameA;
        int i;
        if (editor.noteDisplay.selectedEnd < editor.noteDisplay.selectedStart) {
            return;
        }
        PiyoPiyoFrame[] source = new PiyoPiyoFrame[editor.noteDisplay.selectedEnd - editor.noteDisplay.selectedStart + 1];
        for (i = editor.noteDisplay.selectedStart; i <= editor.noteDisplay.selectedEnd; ++i) {
            frameA = editor.root.coreFile.getFrameOrNull(i, track);
            frameA = frameA == null ? new PiyoPiyoFrame() : new PiyoPiyoFrame(frameA);
            source[i - editor.noteDisplay.selectedStart] = frameA;
        }
        for (i = 0; i < source.length; ++i) {
            frameA = source[i];
            PiyoPiyoFrame frameB = editor.root.coreFile.ensureFrame(frameIndex + i, track);
            for (int p = 0; p < 24; ++p) {
                frameB.hitNotes[p] = frameA.hitNotes[p];
            }
            frameB.panValue = frameA.panValue;
        }
    }

    @Override
    public void onDrag(int frameIndex, int pos, NotesheetGame editor) {
    }
}

