/*
 * Decompiled with CFR 0.152.
 */
package piyopiyoj.games.edittools;

import gabien.GaBIEn;
import gabien.ui.UIElement;
import gabien.ui.elements.UILabel;
import gabien.ui.elements.UIPublicPanel;
import gabien.ui.elements.UITextButton;
import gabien.ui.layouts.UISplitterLayout;
import java.io.OutputStream;
import java.util.function.Consumer;
import libpiyo.export.MidOut;
import libpiyo.export.WavOut;
import libpiyo.export.XMOut;
import piyopiyoj.games.MidiParameterGame;
import piyopiyoj.games.NotesheetGame;
import piyopiyoj.games.edittools.DefaultSemanticsTool;
import piyopiyoj.games.edittools.NoteEditTool;

public class ExportEditTool
extends DefaultSemanticsTool {
    @Override
    public UIElement toolOpened(final NotesheetGame editor) {
        UITextButton exportFile = new UITextButton("Intro", 16, new Runnable(){

            @Override
            public void run() {
                editor.root.fileDialog(true, new Consumer<String>(){

                    @Override
                    public void accept(String s) {
                        if (s == null) {
                            return;
                        }
                        try {
                            OutputStream fos = GaBIEn.getOutFile(s);
                            WavOut.perform(fos, editor.root.coreFile, 0, 0, editor.root.coreFile.loopEnd);
                            fos.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            editor.root.switchError(e, editor);
                        }
                    }
                }, "Export WAV");
            }
        });
        UITextButton exportLoopFile = new UITextButton("Loop", 16, new Runnable(){

            @Override
            public void run() {
                editor.root.fileDialog(true, new Consumer<String>(){

                    @Override
                    public void accept(String s) {
                        if (s == null) {
                            return;
                        }
                        try {
                            OutputStream fos = GaBIEn.getOutFile(s);
                            WavOut.perform(fos, editor.root.coreFile, 0, editor.root.coreFile.loopEnd, editor.root.coreFile.loopEnd - editor.root.coreFile.loopStart);
                            fos.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            editor.root.switchError(e, editor);
                        }
                    }
                }, "Export WAV");
            }
        });
        UITextButton exportMidiFile = new UITextButton("MIDI (*.mid)", 16, new Runnable(){

            @Override
            public void run() {
                editor.root.switcher(new MidiParameterGame(editor.root, new Runnable(){

                    @Override
                    public void run() {
                        editor.root.fileDialog(true, new Consumer<String>(){

                            @Override
                            public void accept(String s) {
                                editor.root.switcher(editor);
                                if (s == null) {
                                    return;
                                }
                                try {
                                    OutputStream fos = GaBIEn.getOutFile(s);
                                    MidOut.perform(fos, editor.root.coreFile);
                                    fos.close();
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                    editor.root.switchError(e, editor);
                                }
                            }
                        }, "Export MID");
                    }
                }));
            }
        });
        UITextButton exportXMFile = new UITextButton("FastTracker II / MilkyTracker (*.xm)", 16, new Runnable(){

            @Override
            public void run() {
                editor.root.fileDialog(true, new Consumer<String>(){

                    @Override
                    public void accept(String s) {
                        if (s == null) {
                            return;
                        }
                        try {
                            OutputStream fos = GaBIEn.getOutFile(s);
                            XMOut.perform(fos, editor.root.coreFile, GaBIEn.nameOf(editor.root.rememberFileName), 32);
                            fos.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            editor.root.switchError(e, editor);
                        }
                    }
                }, "Export XM");
            }
        });
        UIElement rowWAV = UISplitterLayout.produceSideAlignedList(false, false, new UILabel("Wave (*.wav): ", 16), exportFile, new UIPublicPanel(4, 16), exportLoopFile, new UIPublicPanel(1, 1));
        UIElement rowTrk = UISplitterLayout.produceSideAlignedList(false, false, new UILabel("Sequenced: ", 16), exportMidiFile, new UIPublicPanel(16, 16), exportXMFile, new UIPublicPanel(1, 1));
        return NoteEditTool.generateBack(UISplitterLayout.produceSideAlignedList(false, true, rowWAV, rowTrk, new UIPublicPanel(1, 1)), editor);
    }
}

