/*
 * Decompiled with CFR 0.152.
 */
package piyopiyoj.games.edittools;

import gabien.GaBIEn;
import gabien.ui.UIElement;
import gabien.ui.elements.UILabel;
import gabien.ui.layouts.UISplitterLayout;
import piyopiyoj.games.NotesheetGame;
import piyopiyoj.games.edittools.EditTool;
import piyopiyoj.games.edittools.NoteEditTool;

public class BeatTapEditTool
implements EditTool {
    private double lastBeatTime = -1.0;
    private double beatDelta = -1.0;
    private int total = 0;
    private int combo = 0;
    private UILabel lastLabel = new UILabel("", 16);

    @Override
    public UIElement toolOpened(NotesheetGame editor) {
        this.lastLabel = new UILabel("", 16);
        this.regenerateText();
        return NoteEditTool.generateBack(UISplitterLayout.produceSideAlignedList(false, true, this.lastLabel), editor);
    }

    @Override
    public void onClick(int frameIndex, int pos, int button, NotesheetGame editor) {
    }

    @Override
    public void onDrag(int frameIndex, int pos, NotesheetGame editor) {
    }

    @Override
    public boolean keyboardNotifyShouldSuppress() {
        double now = GaBIEn.getTime();
        if (!(this.lastBeatTime < 0.0)) {
            if (this.beatDelta < 0.0) {
                this.beatDelta = now - this.lastBeatTime;
            } else {
                double expectedNextBeat = this.lastBeatTime + this.beatDelta;
                if (Math.abs(expectedNextBeat - now) >= this.beatDelta / 4.0) {
                    this.combo = 0;
                    this.lastBeatTime = now;
                    return true;
                }
                this.beatDelta = (this.beatDelta * (double)this.total + (now - this.lastBeatTime)) / (double)(this.total + 1);
            }
        }
        ++this.total;
        ++this.combo;
        this.lastBeatTime = now;
        this.regenerateText();
        return true;
    }

    private void regenerateText() {
        double bpm = 60.0 / Math.max(this.beatDelta, 0.01);
        String line1 = "BPM: " + bpm + " | Beat Time: " + this.beatDelta * 1000.0 + "\n";
        int snappedBPM = (int)Math.round(Math.max(bpm, 1.0));
        double preSnapBeatTime = 60000.0 / (double)(snappedBPM * 4);
        int snappedBeatTime = (int)Math.round(preSnapBeatTime);
        double scale = preSnapBeatTime / (double)snappedBeatTime;
        double percent = (scale - 1.0) * 100.0;
        String line2 = "Adj. BPM: " + snappedBPM + " | Adj. Time: " + snappedBeatTime + " | Percent: " + percent + "\n";
        this.lastLabel.setText(line1 + line2 + " COMBO x" + this.combo + " TOTAL x" + this.total);
    }
}

