/*
 * Decompiled with CFR 0.152.
 */
package piyopiyoj.games;

import gabien.GaBIEn;
import gabien.ui.UIDynamicProxy;
import gabien.ui.UIElement;
import gabien.ui.elements.UILabel;
import gabien.ui.elements.UINumberBox;
import gabien.ui.elements.UIPublicPanel;
import gabien.ui.elements.UIScrollbar;
import gabien.ui.elements.UITextButton;
import gabien.ui.layouts.UISplitterLayout;
import gabien.uslx.append.Rect;
import gabien.uslx.append.Size;
import gabien.wsi.IDesktopPeripherals;
import gabien.wsi.IPeripherals;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.Consumer;
import libpiyo.PiyoPiyoFrame;
import libpiyo.export.MidOut;
import piyopiyoj.Game;
import piyopiyoj.games.ConfirmGame;
import piyopiyoj.games.edittools.EditTool;
import piyopiyoj.games.edittools.NoteEditTool;
import piyopiyoj.games.ui.UINotesDisplay;
import piyopiyoj.games.ui.UIPlayerControls;
import piyopiyoj.games.ui.UIWaveTrackHeaderEditor;

public class NotesheetGame
extends UIElement.UIPanel {
    public final Game root;
    public UINotesDisplay noteDisplay;
    private UIElement[] trackHeaderEditor = new UIElement[4];
    private EditTool selectedTool;
    private double keybindTickTime = 0.0;
    private UIScrollbar trackScroll = new UIScrollbar(false, 8);
    private double lastScrollPoint = 0.0;
    private UITextButton track1 = (UITextButton)new UITextButton("1", 16, new Runnable(){

        @Override
        public void run() {
            if (((NotesheetGame)NotesheetGame.this).editTrack.state) {
                NotesheetGame.this.attachmentTrackHead(false);
            }
            NotesheetGame.this.noteDisplay.track = 0;
            if (((NotesheetGame)NotesheetGame.this).editTrack.state) {
                NotesheetGame.this.attachmentTrackHead(true);
            }
        }
    }).togglable(true);
    private UITextButton track2 = (UITextButton)new UITextButton("2", 16, new Runnable(){

        @Override
        public void run() {
            if (((NotesheetGame)NotesheetGame.this).editTrack.state) {
                NotesheetGame.this.attachmentTrackHead(false);
            }
            NotesheetGame.this.noteDisplay.track = 1;
            if (((NotesheetGame)NotesheetGame.this).editTrack.state) {
                NotesheetGame.this.attachmentTrackHead(true);
            }
        }
    }).togglable(false);
    private UITextButton track3 = (UITextButton)new UITextButton("3", 16, new Runnable(){

        @Override
        public void run() {
            if (((NotesheetGame)NotesheetGame.this).editTrack.state) {
                NotesheetGame.this.attachmentTrackHead(false);
            }
            NotesheetGame.this.noteDisplay.track = 2;
            if (((NotesheetGame)NotesheetGame.this).editTrack.state) {
                NotesheetGame.this.attachmentTrackHead(true);
            }
        }
    }).togglable(false);
    private UITextButton trackP = (UITextButton)new UITextButton("P", 16, new Runnable(){

        @Override
        public void run() {
            if (((NotesheetGame)NotesheetGame.this).editTrack.state) {
                NotesheetGame.this.attachmentTrackHead(false);
            }
            NotesheetGame.this.noteDisplay.track = 3;
            if (((NotesheetGame)NotesheetGame.this).editTrack.state) {
                NotesheetGame.this.attachmentTrackHead(true);
            }
        }
    }).togglable(false);
    private UITextButton editTrack = (UITextButton)new UITextButton("Edit", 16, new Runnable(){

        @Override
        public void run() {
            if (!((NotesheetGame)NotesheetGame.this).editTrack.state) {
                NotesheetGame.this.attachmentTrackHead(false);
            } else {
                NotesheetGame.this.attachmentTrackHead(true);
            }
        }
    }).togglable(false);
    private UISplitterLayout topPanCB = new UISplitterLayout(this.track1, this.track2, false, 0.0);
    private UISplitterLayout topPanCC = new UISplitterLayout(this.track3, this.trackP, false, 0.0);
    private UISplitterLayout topPanCA = new UISplitterLayout(this.topPanCB, this.topPanCC, false, 0.0);
    private UISplitterLayout topPanC = new UISplitterLayout(this.topPanCA, this.editTrack, false, 0.0);
    private UITextButton loadFile = new UITextButton("Load", 16, new Runnable(){

        @Override
        public void run() {
            NotesheetGame.this.root.fileDialog(false, new Consumer<String>(){

                @Override
                public void accept(String s) {
                    if (s == null) {
                        return;
                    }
                    NotesheetGame.this.root.playerLock.lock();
                    NotesheetGame.this.root.playerControls.setPlaying(false);
                    NotesheetGame.this.root.playerControls.setCurrentFrame(0);
                    NotesheetGame.this.root.playerControls.resetSynth();
                    NotesheetGame.this.root.playerLock.unlock();
                    NotesheetGame.this.root.undoBuffer.clear();
                    NotesheetGame.this.root.redoBuffer.clear();
                    NotesheetGame.this.root.currentModification = null;
                    try {
                        InputStream fis = GaBIEn.getInFile(s);
                        NotesheetGame.this.root.rememberFileName = s;
                        NotesheetGame.this.root.coreFile.loadFile(fis);
                        fis.close();
                        MidOut.setup(s);
                        NotesheetGame.this.root.switcher(new NotesheetGame(NotesheetGame.this.root));
                    }
                    catch (Exception e) {
                        NotesheetGame.this.root.coreFile.reset();
                        NotesheetGame.this.root.switchError(e, new NotesheetGame(NotesheetGame.this.root));
                        e.printStackTrace();
                    }
                    NotesheetGame.this.root.playerControls.resetSynth();
                }
            }, "Load");
        }
    });
    private UITextButton saveFile = new UITextButton("Save", 16, new Runnable(){

        @Override
        public void run() {
            NotesheetGame.this.root.playerLock.lock();
            NotesheetGame.this.root.playerControls.resetSynth();
            NotesheetGame.this.root.coreFile.trimEnd();
            NotesheetGame.this.root.playerControls.setCurrentFrame(NotesheetGame.this.root.playerControls.getCurrentFrame());
            NotesheetGame.this.root.playerLock.unlock();
            NotesheetGame.this.root.fileDialog(true, new Consumer<String>(){

                @Override
                public void accept(String s) {
                    if (s == null) {
                        return;
                    }
                    try {
                        OutputStream fos = GaBIEn.getOutFile(s);
                        NotesheetGame.this.root.rememberFileName = s;
                        NotesheetGame.this.root.coreFile.saveFile(fos);
                        fos.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        NotesheetGame.this.root.switchError(e, NotesheetGame.this);
                    }
                }
            }, "Save");
        }
    });
    private UITextButton configP = new UITextButton("Scale+", 16, new Runnable(){

        @Override
        public void run() {
            NotesheetGame.this.root.switcher(new ConfirmGame(NotesheetGame.this.root, NotesheetGame.this, "Are you sure?\nThis could make the application unusable, causing you to lose unsaved work.\nIn the event something does go wrong, check the readme!", new Runnable(){

                @Override
                public void run() {
                    NotesheetGame.this.root.toggleScale(true);
                }
            }));
        }
    });
    private UITextButton configX = new UITextButton("-", 16, new Runnable(){

        @Override
        public void run() {
            NotesheetGame.this.root.toggleScale(false);
        }
    });
    private UITextButton configFS = new UITextButton("FS", 16, new Runnable(){

        @Override
        public void run() {
            NotesheetGame.this.root.toggleFullscreen();
        }
    });
    private UINumberBox timeFac = new UINumberBox(2L, 16);
    private UITextButton increaseTime = new UITextButton("Tx", 16, new Runnable(){

        @Override
        public void run() {
            NotesheetGame.this.timeFac.setNumber(Math.max(1L, NotesheetGame.this.timeFac.getNumber()));
            NotesheetGame.this.root.startModifications("Time x " + NotesheetGame.this.timeFac.getNumber());
            int fac = Math.max(1, (int)NotesheetGame.this.timeFac.getNumber());
            PiyoPiyoFrame[] oldFrames = NotesheetGame.this.root.coreFile.getAllFrames();
            PiyoPiyoFrame[] newTime = new PiyoPiyoFrame[oldFrames.length * fac];
            for (int i = 0; i < newTime.length; i += fac) {
                newTime[i] = new PiyoPiyoFrame(oldFrames[i / fac]);
                for (int j = 1; j < fac; ++j) {
                    newTime[i + j] = new PiyoPiyoFrame();
                }
            }
            NotesheetGame.this.root.playerLock.lock();
            NotesheetGame.this.root.coreFile.setAllFrames(newTime);
            NotesheetGame.this.root.coreFile.loopStart *= fac;
            NotesheetGame.this.root.coreFile.loopEnd *= fac;
            NotesheetGame.this.root.coreFile.musicWait /= fac;
            NotesheetGame.this.root.playerControls.setCurrentFrame(NotesheetGame.this.root.playerControls.getCurrentFrame() * fac);
            NotesheetGame.this.root.playerLock.unlock();
            NotesheetGame.this.root.endModifications();
            NotesheetGame.this.refresh();
        }
    });
    private UITextButton decreaseTime = new UITextButton("T/", 16, new Runnable(){

        @Override
        public void run() {
            NotesheetGame.this.timeFac.setNumber(Math.max(1L, NotesheetGame.this.timeFac.getNumber()));
            NotesheetGame.this.root.startModifications("Time / " + NotesheetGame.this.timeFac.getNumber());
            int fac = Math.max(1, (int)NotesheetGame.this.timeFac.getNumber());
            PiyoPiyoFrame[] oldFrames = NotesheetGame.this.root.coreFile.getAllFrames();
            int totalInputCols = oldFrames.length / 4;
            int totalOutputCols = totalInputCols / fac;
            PiyoPiyoFrame[] newTime = new PiyoPiyoFrame[totalOutputCols * 4];
            for (int i = 0; i < totalOutputCols; ++i) {
                for (int j = 0; j < 4; ++j) {
                    PiyoPiyoFrame frame;
                    newTime[i + j * totalOutputCols] = frame = new PiyoPiyoFrame();
                    for (int k = 0; k < fac; ++k) {
                        frame.merge(oldFrames[i * fac + k + j * totalInputCols]);
                    }
                }
            }
            NotesheetGame.this.root.playerLock.lock();
            NotesheetGame.this.root.coreFile.setAllFrames(newTime);
            NotesheetGame.this.root.coreFile.loopStart /= fac;
            NotesheetGame.this.root.coreFile.loopEnd /= fac;
            NotesheetGame.this.root.coreFile.musicWait *= fac;
            NotesheetGame.this.root.playerControls.setCurrentFrame(NotesheetGame.this.root.playerControls.getCurrentFrame() / fac);
            NotesheetGame.this.root.playerLock.unlock();
            NotesheetGame.this.root.endModifications();
            NotesheetGame.this.refresh();
        }
    });
    private UITextButton undo = new UITextButton("Undo", 16, new Runnable(){

        @Override
        public void run() {
            NotesheetGame.this.root.undoModifications();
            NotesheetGame.this.refresh();
        }
    });
    private UITextButton redo = new UITextButton("Redo", 16, new Runnable(){

        @Override
        public void run() {
            NotesheetGame.this.root.redoModifications();
            NotesheetGame.this.refresh();
        }
    });
    private UITextButton clearDoBuffer = new UITextButton("X", 16, new Runnable(){

        @Override
        public void run() {
            NotesheetGame.this.root.switcher(new ConfirmGame(NotesheetGame.this.root, NotesheetGame.this, "Are you sure you want to clear the undo/redo buffers?", new Runnable(){

                @Override
                public void run() {
                    NotesheetGame.this.root.undoBuffer.clear();
                    NotesheetGame.this.root.redoBuffer.clear();
                    NotesheetGame.this.root.currentModification = null;
                    NotesheetGame.this.refresh();
                }
            }));
        }
    });
    private UILabel waitLabel = new UILabel("Beat Len:", 16);
    private UILabel drumVolumeLabel = new UILabel("Drum Vol:", 16);
    private UINumberBox waitBox = new UINumberBox(0L, 16);
    private UINumberBox drumVolumeBox = new UINumberBox(0L, 16);
    private UISplitterLayout major;
    private UIDynamicProxy toolVS = new UIDynamicProxy();
    private int waitingKey = -1;
    private HashMap<Integer, Integer> bindings = new HashMap();

    public NotesheetGame(final Game root) {
        super(640, 480);
        this.root = root;
        this.noteDisplay = new UINotesDisplay(root.coreFile, aBoolean -> {
            root.playerLock.lock();
            root.playerControls.setCurrentFrame(root.playerControls.getCurrentFrame() + (aBoolean != false ? -1 : 1));
            root.playerLock.unlock();
        });
        UIPlayerControls playerControls = new UIPlayerControls(root.playerControls);
        UISplitterLayout trackAndPlayC = new UISplitterLayout(this.topPanC, playerControls, false, 0.0);
        UIElement fileControlsL0I0 = UISplitterLayout.produceSideAlignedList(false, false, this.loadFile, this.saveFile);
        UISplitterLayout fileControlsL0I1 = new UISplitterLayout(new UISplitterLayout(this.increaseTime, this.decreaseTime, false, 0.5), this.timeFac, false, 0.0);
        UISplitterLayout fileControlsL0I2 = new UISplitterLayout(new UISplitterLayout(this.undo, this.redo, false, 0.5), this.clearDoBuffer, false, 0.5);
        UISplitterLayout fileControlsL0I3 = new UISplitterLayout(this.waitLabel, this.waitBox, false, 0.0);
        UISplitterLayout fileControlsL0I4 = new UISplitterLayout(this.drumVolumeLabel, this.drumVolumeBox, false, 0.0);
        UIElement fileControlsL0I5 = UISplitterLayout.produceSideAlignedList(false, false, this.configFS, this.configP, this.configX);
        UIElement fileControls = UISplitterLayout.produceSideAlignedList(false, false, fileControlsL0I0, new UIPublicPanel(16, 0), fileControlsL0I1, new UIPublicPanel(16, 0), fileControlsL0I2, new UIPublicPanel(16, 0), fileControlsL0I3, new UIPublicPanel(16, 0), fileControlsL0I4, new UIPublicPanel(16, 0), fileControlsL0I5, new UIPublicPanel(16, 0));
        UISplitterLayout minor = new UISplitterLayout(this.toolVS, fileControls, true, 1.0);
        UISplitterLayout ts = new UISplitterLayout(this.trackScroll, trackAndPlayC, true, 0.0);
        this.major = new UISplitterLayout(ts, minor, true, 0.0);
        this.waitBox.onEdit = new Runnable(){

            @Override
            public void run() {
                root.startModifications("Beat Length");
                root.coreFile.musicWait = (int)NotesheetGame.this.waitBox.getNumber();
                root.endModifications();
            }
        };
        this.drumVolumeBox.onEdit = new Runnable(){

            @Override
            public void run() {
                root.startModifications("Drum Volume");
                root.coreFile.drumVolume = (int)NotesheetGame.this.drumVolumeBox.getNumber();
                root.endModifications();
                root.playerControls.regenWaveforms();
            }
        };
        for (int i = 0; i < 3; ++i) {
            this.trackHeaderEditor[i] = new UIWaveTrackHeaderEditor(root, root.coreFile.waveTracks[i]);
        }
        this.refresh();
        UIPublicPanel dummy = new UIPublicPanel(640, 384){
            UILabel label;
            String textBuffer;
            {
                this.textBuffer = "PiyoPiyoJ v7-RC\nBrought to you by:\n20kdc\nJazz Jackalope, for the piano-keys text patch, and testing\nzxin, for more testing.\nIndirectly, Studio Pixel, for the sounds I put into piyoDrums.bin\n(Please don't sue me?)\n\n\nHopefully I didn't miss anything, so with that -\n I now end the message.";
            }

            @Override
            public void initialize() {
                this.label = new UILabel("", 16);
                this.layoutAddElement(this.label);
            }

            @Override
            public void layoutRunImpl() {
                Size s = this.getSize();
                this.label.setForcedBounds(this, new Rect(8, s.height - (this.label.getWantedSize().height + 8), s.width - 16, this.label.getWantedSize().height));
            }

            @Override
            public void update(double deltaTime, boolean selected, IPeripherals peripherals) {
                super.update(deltaTime, selected, peripherals);
                this.label.setText(this.textBuffer);
            }
        };
        dummy.imageScale = true;
        dummy.imageSW = 320;
        dummy.imageSH = 192;
        this.trackHeaderEditor[3] = dummy;
        final NotesheetGame toolCallbackNG = this;
        this.noteDisplay.toolCallback = new UINotesDisplay.NoteClickCallback(){

            @Override
            public void onClick(int frameIndex, int pos, int button) {
                root.startModifications("Tool use");
                NotesheetGame.this.selectedTool.onClick(frameIndex, pos, button, toolCallbackNG);
            }

            @Override
            public void onDrag(int frameIndex, int pos) {
                NotesheetGame.this.selectedTool.onDrag(frameIndex, pos, toolCallbackNG);
            }

            @Override
            public void onRelease() {
                root.endModifications();
            }

            @Override
            public void onFingerClick(int i, int button) {
                root.playerControls.playNote(NotesheetGame.this.noteDisplay.track, i);
                if (button == 3) {
                    NotesheetGame.this.waitingKey = i;
                }
            }

            @Override
            public void prePC() {
                root.startModifications("Pan change");
            }

            @Override
            public void postPC() {
                root.endModifications();
            }
        };
        this.selectTool(new NoteEditTool());
        this.layoutAddElement(this.noteDisplay);
        for (int i = 0; i < this.trackHeaderEditor.length; ++i) {
            this.layoutAddElement(this.trackHeaderEditor[i]);
            this.layoutSetElementVis(this.trackHeaderEditor[i], false);
        }
        this.layoutAddElement(this.major);
        this.layoutRunImpl();
        this.bindings.put(15, 2);
        this.bindings.put(16, 5);
        this.bindings.put(17, 8);
        this.bindings.put(18, 11);
        this.bindings.put(19, 14);
        this.bindings.put(20, 17);
        this.bindings.put(21, 20);
        this.bindings.put(22, 23);
        this.bindings.put(29, 1);
        this.bindings.put(30, 4);
        this.bindings.put(31, 7);
        this.bindings.put(32, 10);
        this.bindings.put(33, 13);
        this.bindings.put(34, 16);
        this.bindings.put(35, 19);
        this.bindings.put(36, 22);
        this.bindings.put(41, 0);
        this.bindings.put(42, 0);
        this.bindings.put(43, 3);
        this.bindings.put(44, 6);
        this.bindings.put(45, 9);
        this.bindings.put(46, 12);
        this.bindings.put(47, 15);
        this.bindings.put(48, 18);
        this.bindings.put(49, 21);
    }

    private void attachmentTrackHead(boolean b) {
        this.layoutSetElementVis(this.noteDisplay, !b);
        for (int i = 0; i < this.trackHeaderEditor.length; ++i) {
            this.layoutSetElementVis(this.trackHeaderEditor[i], b && i == this.noteDisplay.track);
        }
        if (this.editTrack.state == b) {
            this.layoutRunImpl();
        }
    }

    public void selectTool(EditTool editTool) {
        this.selectedTool = editTool;
        this.toolVS.dynProxySet(editTool.toolOpened(this));
    }

    @Override
    public void update(double deltaTime, boolean selected, IPeripherals peripherals) {
        this.undo.setText(this.root.undoBuffer.size() > 0 ? "Undo" : "----");
        this.redo.setText(this.root.redoBuffer.size() > 0 ? "Redo" : "----");
        int mfl = this.root.coreFile.getFrameCount();
        if (this.trackScroll.scrollPoint != this.lastScrollPoint) {
            this.root.playerLock.lock();
            this.root.playerControls.setCurrentFrame(Math.max((int)(this.trackScroll.scrollPoint * (double)mfl), 0));
            this.root.playerLock.unlock();
        }
        int refCurrentFrame = (int)Math.floor(this.root.playerControls.getFrameInterpolatedPrecise());
        this.lastScrollPoint = this.trackScroll.scrollPoint = (double)refCurrentFrame / (double)mfl;
        this.keybindTickTime -= deltaTime;
        if (this.keybindTickTime <= 0.0) {
            this.keybindTickTime = 0.1;
            if (peripherals instanceof IDesktopPeripherals) {
                IDesktopPeripherals idp = (IDesktopPeripherals)peripherals;
                if (idp.isKeyDown(89)) {
                    this.root.playerLock.lock();
                    this.root.playerControls.setCurrentFrame(refCurrentFrame - 1);
                    this.root.playerLock.unlock();
                }
                if (idp.isKeyDown(90)) {
                    this.root.playerLock.lock();
                    this.root.playerControls.setCurrentFrame(refCurrentFrame + 1);
                    this.root.playerLock.unlock();
                }
            }
        }
        this.noteDisplay.xOffset = refCurrentFrame - 1;
        this.track1.state = this.noteDisplay.track == 0;
        this.track2.state = this.noteDisplay.track == 1;
        this.track3.state = this.noteDisplay.track == 2;
        this.trackP.state = this.noteDisplay.track == 3;
        for (int i = 0; i < this.noteDisplay.fingerInvert.length; ++i) {
            this.noteDisplay.fingerInvert[i] = false;
            if (this.waitingKey != i) continue;
            this.noteDisplay.fingerInvert[i] = ((long)GaBIEn.getTime() & 1L) == 0L;
        }
        if (peripherals instanceof IDesktopPeripherals) {
            Object hsi;
            Iterator<Integer> iterator;
            IDesktopPeripherals idp = (IDesktopPeripherals)peripherals;
            if (this.waitingKey != -1 && (iterator = ((HashSet)(hsi = idp.activeKeys())).iterator()).hasNext()) {
                Integer i = iterator.next();
                this.bindings.put(i, this.waitingKey);
                this.waitingKey = -1;
            }
            for (Map.Entry entry : this.bindings.entrySet()) {
                if (idp.isKeyJustPressed((Integer)entry.getKey()) && !this.selectedTool.keyboardNotifyShouldSuppress()) {
                    this.root.playerControls.playNote(this.noteDisplay.track, (Integer)entry.getValue());
                }
                if (!idp.isKeyDown((Integer)entry.getKey())) continue;
                this.noteDisplay.fingerInvert[((Integer)entry.getValue()).intValue()] = true;
            }
            if (idp.isKeyJustPressed(0)) {
                System.err.println("// right click on fingers to prepare for binding, use ESC to get table for src.");
                LinkedList<Integer> k = new LinkedList<Integer>(this.bindings.keySet());
                Collections.sort(k);
                for (Integer i : k) {
                    System.err.println("bindings.put(" + i + ", " + this.bindings.get(i) + ");");
                }
            }
        }
        super.update(deltaTime, selected, peripherals);
    }

    private void refresh() {
        this.waitBox.setNumber(this.root.coreFile.musicWait);
        this.drumVolumeBox.setNumber(this.root.coreFile.drumVolume);
        ((UIWaveTrackHeaderEditor)this.trackHeaderEditor[0]).refresh();
        ((UIWaveTrackHeaderEditor)this.trackHeaderEditor[1]).refresh();
        ((UIWaveTrackHeaderEditor)this.trackHeaderEditor[2]).refresh();
    }

    @Override
    protected void layoutRunImpl() {
        int noteDisplayHeight = this.noteDisplay.getWantedSize().height;
        for (int i = 0; i < this.trackHeaderEditor.length; ++i) {
            noteDisplayHeight = Math.max(noteDisplayHeight, this.trackHeaderEditor[i].getWantedSize().height);
        }
        Size s = this.getSize();
        Rect rb = new Rect(0, 0, s.width, noteDisplayHeight);
        if (this.editTrack.state) {
            this.trackHeaderEditor[this.noteDisplay.track].setForcedBounds(this, rb);
        } else {
            this.noteDisplay.setForcedBounds(this, rb);
        }
        this.major.setForcedBounds(this, new Rect(0, noteDisplayHeight, s.width, s.height - noteDisplayHeight));
    }
}

