/*
 * Decompiled with CFR 0.152.
 */
package piyopiyoj;

import java.util.concurrent.locks.ReentrantLock;
import libpiyo.PiyoPiyoFile;
import libpiyo.PiyoPiyoPlayer;
import libpiyo.SimpleMixer;

public class PlayerControls {
    private boolean playing;
    public boolean reverse;
    public boolean halfSpeed;
    public final ReentrantLock playerLock;
    private final PiyoPiyoPlayer target;
    public boolean useRefTrack = true;
    public short[] refTrack = new short[1];
    public int refTrackPtr = 0;
    public final PiyoPiyoFile coreFile;
    private long withinBeatPositionLastUpdatedTime;

    public PlayerControls(ReentrantLock pl, PiyoPiyoFile file, SimpleMixer mixer, int baseSoundId) {
        this.playerLock = pl;
        this.target = new PiyoPiyoPlayer(file, mixer, baseSoundId);
        this.coreFile = file;
    }

    public void runTick(double deltaTime) {
        double speed;
        double d = speed = this.halfSpeed ? deltaTime / 2.0 : deltaTime;
        if (this.playing) {
            this.target.updateBeats(this.reverse ? -speed : speed);
        }
        this.withinBeatPositionLastUpdatedTime = System.currentTimeMillis();
    }

    public void setPlaying(boolean value) {
        this.playerLock.lock();
        this.playing = value;
        this.target.withinBeatPosition = 0.0;
        this.withinBeatPositionLastUpdatedTime = System.currentTimeMillis();
        this.updateRefTrackPtr();
        this.playerLock.unlock();
    }

    private void updateRefTrackPtr() {
        int res;
        int direction = this.reverse ? -1 : 1;
        double exactSample = (double)(this.target.currentFrame - direction) * this.coreFile.beatTime() * 22050.0;
        this.refTrackPtr = res = (int)exactSample * 2;
    }

    public boolean getPlaying() {
        return this.playing;
    }

    public void setCurrentFrame(int frame) {
        this.playerLock.lock();
        this.target.setCurrentFrame(frame);
        this.withinBeatPositionLastUpdatedTime = System.currentTimeMillis();
        this.updateRefTrackPtr();
        this.playerLock.unlock();
    }

    public int getCurrentFrame() {
        return this.target.currentFrame;
    }

    public void resetSynth() {
        this.playerLock.lock();
        this.target.resetSynth();
        this.playerLock.unlock();
    }

    public void regenWaveforms() {
        this.playerLock.lock();
        this.target.regenWaveforms();
        this.playerLock.unlock();
    }

    public double getFrameInterpolatedPrecise() {
        double res;
        this.playerLock.lock();
        if (this.playing) {
            double speed = (this.halfSpeed ? 0.5 : 1.0) * 0.8;
            speed = this.reverse ? -speed : speed;
            long movementMillis = System.currentTimeMillis() - this.withinBeatPositionLastUpdatedTime;
            double movementSeconds = (double)movementMillis / 1000.0 * speed;
            double musicWaitTime = this.target.piyoFile.beatTime();
            res = (double)this.target.currentFrame + (this.target.withinBeatPosition + movementSeconds) / musicWaitTime;
        } else {
            res = this.target.currentFrame;
        }
        this.playerLock.unlock();
        return res;
    }

    public void playNote(int track, int i) {
        this.playerLock.lock();
        this.target.playNote(track, i);
        this.playerLock.unlock();
    }

    public boolean getHandleLoop() {
        return this.target.handleLoop;
    }

    public void setHandleLoop(boolean state) {
        this.target.handleLoop = state;
    }
}

