/*
 * Decompiled with CFR 0.152.
 */
package piyopiyoj;

import gabien.GaBIEn;
import gabien.audio.IRawAudioDriver;
import gabien.ui.UIElement;
import gabien.ui.WindowCreatingUIElementConsumer;
import gabien.ui.elements.UILabel;
import gabien.ui.elements.UITextButton;
import gabien.ui.layouts.UISplitterLayout;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.LinkedList;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import libpiyo.PiyoPiyoFile;
import libpiyo.PiyoPiyoPlayingSample;
import libpiyo.SimpleMixer;
import org.eclipse.jdt.annotation.NonNull;
import piyopiyoj.PlayerControls;
import piyopiyoj.UIGame;
import piyopiyoj.games.NotesheetGame;

public class Game {
    public static final String FILE_X2 = "PiyoPiyoJ.X2";
    public static final String FILE_X3 = "PiyoPiyoJ.X3";
    public static final String FILE_FS = "PiyoPiyoJ.FS";
    private UIGame outerGame;
    public final SimpleMixer coreMixer = new SimpleMixer(96, 1);
    public final PiyoPiyoFile coreFile = new PiyoPiyoFile();
    public String rememberFileName = "Blank.pmd";
    public final ReentrantLock playerLock = new ReentrantLock();
    public final PlayerControls playerControls = new PlayerControls(this.playerLock, this.coreFile, this.coreMixer, 0);
    private final WindowCreatingUIElementConsumer worldCreator = new WindowCreatingUIElementConsumer();
    public LinkedList<PiyoPiyoFile> undoBuffer = new LinkedList();
    public LinkedList<PiyoPiyoFile> redoBuffer = new LinkedList();
    public String currentModification = null;

    private double recommendedDeltaTime() {
        if (!this.playerControls.getPlaying()) {
            return 0.05;
        }
        double beatTime = this.coreFile.beatTime();
        if (this.playerControls.halfSpeed) {
            beatTime *= 2.0;
        }
        return beatTime / 8.0;
    }

    public void runFrame() {
        double wakeUpTime;
        for (wakeUpTime = this.recommendedDeltaTime(); wakeUpTime > 0.05; wakeUpTime /= 2.0) {
        }
        double deltaTime = GaBIEn.endFrame(wakeUpTime);
        if (this.worldCreator.runningWindows().size() == 0) {
            GaBIEn.ensureQuit();
        }
        try {
            this.worldCreator.runTick(deltaTime);
        }
        catch (Exception e) {
            if (this.currentModification != null) {
                this.currentModification = null;
                if (this.undoBuffer.size() > 0) {
                    this.coreFile.copyFrom(this.undoBuffer.removeLast());
                }
            }
            String saveState = "Data has been lost.";
            if (this.saveBackup()) {
                saveState = "Data saved to 'PPJ-BACKUP.pmd'.";
            }
            try {
                this.switchError(e, new NotesheetGame(this));
            }
            catch (Exception e2) {
                this.switchError(e, new UILabel("Exception occurred during recovery. " + saveState, 16));
            }
        }
    }

    private boolean saveBackup() {
        try {
            OutputStream os = GaBIEn.getOutFile("PPJ-BACKUP.pmd");
            this.coreFile.saveFile(os);
            os.close();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void resetInitLauncher() throws IOException {
        this.outerGame = new UIGame();
        this.doWCAccept();
        NotesheetGame ng = new NotesheetGame(this);
        try {
            PiyoPiyoPlayingSample.ensureAllSamplesLoaded();
            this.switcher(ng);
        }
        catch (IOException ioe) {
            this.switchError(ioe, ng);
        }
        IRawAudioDriver rad = GaBIEn.getRawAudio();
        rad.setRawAudioSource(new IRawAudioDriver.IRawAudioSource(){

            @Override
            public void pullData(@NonNull short[] interleaved, int ofs, int frames) {
                int blk = 880;
                while (frames > blk) {
                    this.pullData(interleaved, ofs, blk);
                    ofs += blk * 2;
                    frames -= blk;
                }
                Game.this.playerLock.lock();
                Game.this.playerControls.runTick((double)frames / 22050.0);
                Game.this.coreMixer.pullData(interleaved, ofs, frames);
                int ptr = Game.this.playerControls.refTrackPtr;
                if (Game.this.playerControls.getPlaying()) {
                    int direction;
                    int n = direction = Game.this.playerControls.reverse ? -1 : 1;
                    if (Game.this.playerControls.useRefTrack) {
                        short[] refTrack = Game.this.playerControls.refTrack;
                        int ofs2 = ofs;
                        for (int i = 0; i < frames * 2; ++i) {
                            int v = interleaved[ofs2];
                            if (ptr >= 0 && ptr < refTrack.length) {
                                v += refTrack[ptr] >> 1;
                                ptr += direction;
                            }
                            interleaved[ofs2++] = (short)(v >>= 1);
                        }
                    }
                    Game.this.playerControls.refTrackPtr += frames * 2 * direction;
                }
                Game.this.playerLock.unlock();
            }
        });
    }

    private void tsMakeFile(String str) {
        try {
            OutputStream os = GaBIEn.getOutFile(str);
            os.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void toggleScale(boolean positive) {
        if (positive) {
            if (!GaBIEn.fileOrDirExists(FILE_X3)) {
                if (GaBIEn.fileOrDirExists(FILE_X2)) {
                    this.tsMakeFile(FILE_X3);
                    GaBIEn.rmFile(FILE_X2);
                } else {
                    this.tsMakeFile(FILE_X2);
                }
            }
            this.saveBackup();
        } else if (GaBIEn.fileOrDirExists(FILE_X3)) {
            GaBIEn.rmFile(FILE_X3);
            this.tsMakeFile(FILE_X2);
        } else if (GaBIEn.fileOrDirExists(FILE_X2)) {
            GaBIEn.rmFile(FILE_X2);
        }
        this.worldCreator.forceRemove(this.outerGame);
        this.doWCAccept();
    }

    public void toggleFullscreen() {
        if (GaBIEn.fileOrDirExists(FILE_FS)) {
            GaBIEn.rmFile(FILE_FS);
        } else {
            this.tsMakeFile(FILE_FS);
        }
        this.worldCreator.forceRemove(this.outerGame);
        this.doWCAccept();
    }

    private void doWCAccept() {
        int scale = 1;
        if (GaBIEn.fileOrDirExists(FILE_X3)) {
            scale = 3;
        } else if (GaBIEn.fileOrDirExists(FILE_X2)) {
            scale = 2;
        }
        this.worldCreator.accept(this.outerGame, scale, GaBIEn.fileOrDirExists(FILE_FS));
    }

    public void switcher(UIElement returnGame) {
        this.outerGame.changeElement(returnGame);
    }

    public void fileDialog(boolean saving, final Consumer<String> recipient, String verb) {
        String here = GaBIEn.absolutePathOf("./");
        final UIElement currentGame = this.outerGame.getElement();
        this.outerGame.changeElement(new UILabel("Selecting a file: " + verb, 16));
        GaBIEn.startFileBrowser(here, saving, "", new Consumer<String>(){

            @Override
            public void accept(String t) {
                Game.this.switcher(currentGame);
                recipient.accept(t);
            }
        });
    }

    public void switchError(Exception e, final UIElement notesheetGame) {
        String ef = "Exception occurred! Details follow...\n";
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        pw.flush();
        ef = ef + sw.toString().replace("\r\n", "\n").replace("\t", "    ");
        this.switcher(new UISplitterLayout(new UILabel(ef, 16), new UITextButton("Continue", 16, new Runnable(){

            @Override
            public void run() {
                Game.this.switcher(notesheetGame);
            }
        }), true, 1.0));
    }

    public void startModifications(String s) {
        this.redoBuffer.clear();
        this.undoBuffer.add(new PiyoPiyoFile(this.coreFile));
    }

    public void endModifications() {
        if (this.currentModification != null) {
            this.currentModification = null;
        }
    }

    public void undoModifications() {
        if (this.undoBuffer.size() > 0) {
            this.redoBuffer.add(new PiyoPiyoFile(this.coreFile));
            this.coreFile.copyFrom(this.undoBuffer.removeLast());
        }
    }

    public void redoModifications() {
        if (this.redoBuffer.size() > 0) {
            this.undoBuffer.add(new PiyoPiyoFile(this.coreFile));
            this.coreFile.copyFrom(this.redoBuffer.removeLast());
        }
    }
}

