/*
 * Decompiled with CFR 0.152.
 */
package libpiyo.export;

import gabien.GaBIEn;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.LinkedList;
import libpiyo.PiyoPiyoFile;
import libpiyo.PiyoPiyoFrame;
import libpiyo.PiyoPiyoPlayingSample;
import libpiyo.PiyoPiyoWaveTrack;
import libpiyo.export.XMCell;
import libpiyo.export.XMInstrumentConversion;
import libpiyo.export.XMInstrumentOut;

public class XMOut {
    public static final int DRUMVOL_RATIO_MUL_Q = 3;
    public static final int DRUMVOL_RATIO_MUL_L = 4;
    public static final int DRUMVOL_RATIO_DIV = 4;

    public static void main(String[] args) throws Exception {
        if (args.length != 3) {
            throw new RuntimeException("Expects three arguments, source .pmd, target .xm, channel count");
        }
        GaBIEn.initializeEmbedded();
        try {
            PiyoPiyoPlayingSample.ensureAllSamplesLoaded();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        PiyoPiyoFile ppf = new PiyoPiyoFile();
        ppf.loadFile(GaBIEn.getInFile(args[0]));
        int chc = Integer.valueOf(args[2]);
        OutputStream os = GaBIEn.getOutFile(args[1]);
        XMOut.perform(os, ppf, GaBIEn.nameOf(args[0]), chc);
        os.close();
    }

    public static void perform(OutputStream os, PiyoPiyoFile ppf, String basename, int channels) throws IOException {
        int i;
        int i2;
        int rowsPerPattern = 64;
        int patterns = (ppf.loopEnd + rowsPerPattern - 1) / rowsPerPattern;
        int instruments = 9;
        int tempo = 4;
        int bpm = 125;
        double target = ppf.beatTime();
        double closeness = Double.MAX_VALUE;
        for (int xTempo = 1; xTempo <= 31; ++xTempo) {
            for (int xBPM = 32; xBPM <= 255; ++xBPM) {
                double tc = Math.abs(target - XMOut.secondsPerRowXM(xTempo, xBPM));
                if (!(tc < closeness)) continue;
                tempo = xTempo;
                bpm = xBPM;
                closeness = tc;
            }
        }
        XMOut.putHeader(os, channels, patterns, instruments, tempo, bpm, ppf.loopStart / rowsPerPattern, basename);
        int[] iVolumes = new int[]{ppf.waveTracks[0].volume, ppf.waveTracks[1].volume, ppf.waveTracks[2].volume, ppf.drumVolume};
        int maxVolume = 0;
        for (i2 = 0; i2 < iVolumes.length; ++i2) {
            if (maxVolume >= iVolumes[i2]) continue;
            maxVolume = iVolumes[i2];
        }
        for (i2 = 0; i2 < iVolumes.length; ++i2) {
            iVolumes[i2] = iVolumes[i2] * 64 / maxVolume;
        }
        int channelRotation = 0;
        int currentFrame = 0;
        int[] panning = new int[]{3, 3, 3, 3};
        int[] panningTable = new int[]{32, 64, 96, 128, 160, 192, 224};
        for (i = 0; i < patterns; ++i) {
            XMCell[] cells = new XMCell[rowsPerPattern * channels];
            for (int j = 0; j < cells.length; ++j) {
                cells[j] = new XMCell();
            }
            int rowCellBase = 0;
            for (int j = 0; j < rowsPerPattern; ++j) {
                for (int k = 0; k < 4; ++k) {
                    PiyoPiyoFrame cf = ppf.getFrameOrNull(currentFrame, k);
                    if (cf == null) continue;
                    if (cf.panValue != 0) {
                        panning[k] = cf.panValue - 1;
                    }
                    for (int n = 0; n < 24; ++n) {
                        if (!cf.hitNotes[n]) continue;
                        XMCell cell = cells[rowCellBase + channelRotation];
                        if (k != 3) {
                            cell.clear();
                            int noteAdj = n + ppf.waveTracks[k].octave * 12 + 1;
                            if (noteAdj < 1) {
                                noteAdj = 1;
                            }
                            if (noteAdj > 127) {
                                noteAdj = 127;
                            }
                            cell.note = (byte)noteAdj;
                            cell.instrument = (byte)(k + 1);
                        } else {
                            int drumId = PiyoPiyoPlayingSample.drumTable[n / 2];
                            if (drumId == -1) continue;
                            boolean louder = n % 2 == 0;
                            cell.clear();
                            cell.note = (byte)49;
                            cell.instrument = (byte)(drumId + 4);
                            cell.volume = (byte)(iVolumes[3] * (louder ? 4 : 3) / 4);
                        }
                        cell.effect = (byte)8;
                        cell.effectParam = (byte)panningTable[panning[k]];
                        ++channelRotation;
                        channelRotation %= channels;
                    }
                }
                if (currentFrame == ppf.loopEnd - 1) {
                    XMCell ef1 = cells[rowCellBase + channelRotation];
                    ef1.effect = (byte)13;
                    int jumpRow = ppf.loopStart % rowsPerPattern;
                    int jumpRowDec = jumpRow % 10 + jumpRow / 10 * 16;
                    ef1.effectParam = (byte)jumpRowDec;
                    ++channelRotation;
                    channelRotation %= channels;
                }
                ++currentFrame;
                rowCellBase += channels;
            }
            XMCell.putPattern(os, cells, channels);
        }
        for (i = 0; i < 3; ++i) {
            PiyoPiyoWaveTrack wt = ppf.waveTracks[i];
            LinkedList<XMInstrumentOut.Point> points = XMInstrumentConversion.convIPoints(wt, bpm);
            XMInstrumentConversion.rmOverlappingPoints(points);
            XMInstrumentConversion.complexStripIPoints(points);
            XMInstrumentOut.putInstrument(os, "Melody " + i, points, wt.waveForm, iVolumes[i]);
        }
        for (i = 0; i < 6; ++i) {
            short[] perc = PiyoPiyoPlayingSample.samples[i];
            if (perc == null) {
                perc = new short[1];
            }
            XMInstrumentOut.putInstrumentPercussion(os, "Drum " + i, perc);
        }
    }

    public static double secondsPerRowXM(int tempo, int bpm) {
        double rpm = 24.0 * (double)bpm / (double)tempo;
        return 60.0 / rpm;
    }

    public static void putHeader(OutputStream os, int channels, int patterns, int instruments, int tempo, int bpm, int restartPosition, String basename) throws IOException {
        ByteBuffer bb = ByteBuffer.allocate(336);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        bb.put("Extended Module: ".getBytes("UTF-8"));
        XMOut.putTextInBB(bb, basename, 20);
        bb.put((byte)26);
        XMOut.putTextInBB(bb, "PiyoPiyoJ v7-RC Export", 20);
        bb.putShort((short)260);
        bb.putInt(276);
        bb.putShort((short)patterns);
        bb.putShort((short)restartPosition);
        bb.putShort((short)channels);
        bb.putShort((short)patterns);
        bb.putShort((short)instruments);
        bb.putShort((short)1);
        bb.putShort((short)tempo);
        bb.putShort((short)bpm);
        for (int i = 0; i < 256; ++i) {
            bb.put((byte)i);
        }
        os.write(bb.array());
    }

    public static void putTextInBB(ByteBuffer bb, String text, int len) throws IOException {
        String charset = "SHIFT_JIS";
        byte[] data = text.getBytes(charset);
        while (data.length > len) {
            text = text.substring(0, text.length() - 1);
            data = text.getBytes(charset);
        }
        bb.put(data);
        for (int i = data.length; i < len; ++i) {
            bb.put((byte)32);
        }
    }
}

