/*
 * Decompiled with CFR 0.152.
 */
package libpiyo.export;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.LinkedList;
import libpiyo.export.XMOut;

public class XMInstrumentOut {
    public static final int INSTRUMENT_HEADER_SIZE = 29;
    public static final int INSTRUMENT_HEADER2_SIZE = 214;
    public static final int INSTRUMENT_SH_SIZE = 40;

    public static void putInstrumentHeader(ByteBuffer bb, String name, int samples, int totalSize) throws IOException {
        bb.putInt(totalSize);
        XMOut.putTextInBB(bb, name, 22);
        bb.put((byte)0);
        bb.putShort((short)samples);
    }

    public static void putInstrument(OutputStream os, String name, LinkedList<Point> points, int[] waveForm, int vol) throws IOException {
        int i;
        ByteBuffer bb = ByteBuffer.allocate(283 + waveForm.length);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        XMInstrumentOut.putInstrumentHeader(bb, name, 1, 243);
        bb.putInt(40);
        for (int i2 = 0; i2 < 96; ++i2) {
            bb.put((byte)0);
        }
        int pointCount = points.size();
        if (pointCount > 12) {
            throw new RuntimeException("maximum of 12 points allowed");
        }
        for (Point p : points) {
            bb.putShort(p.x);
            bb.putShort(p.y);
        }
        for (i = pointCount; i < 12; ++i) {
            bb.putShort((short)0);
            bb.putShort((short)0);
        }
        for (i = 0; i < 24; ++i) {
            bb.putShort((short)0);
        }
        bb.put((byte)pointCount);
        bb.put((byte)2);
        bb.put((byte)0);
        bb.put((byte)0);
        bb.put((byte)0);
        bb.put((byte)0);
        bb.put((byte)0);
        bb.put((byte)0);
        bb.put((byte)1);
        bb.put((byte)0);
        bb.put((byte)0);
        bb.put((byte)0);
        bb.put((byte)0);
        bb.put((byte)0);
        bb.putShort((short)0);
        bb.putShort((short)0);
        bb.putInt(waveForm.length);
        bb.putInt(0);
        bb.putInt(waveForm.length);
        bb.put((byte)vol);
        bb.put((byte)0);
        bb.put((byte)1);
        bb.put((byte)-128);
        bb.put((byte)48);
        bb.put((byte)0);
        XMOut.putTextInBB(bb, "Melody", 22);
        int running = 0;
        for (int i3 = 0; i3 < waveForm.length; ++i3) {
            int val = waveForm[i3];
            bb.put((byte)(val - running));
            running = val;
        }
        os.write(bb.array());
    }

    public static void putInstrumentPercussion(OutputStream os, String name, short[] data) throws IOException {
        int i;
        ByteBuffer bb = ByteBuffer.allocate(283 + data.length * 2);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        XMInstrumentOut.putInstrumentHeader(bb, name, 1, 243);
        if (bb.position() != 29) {
            throw new RuntimeException("Bad instrument H1 alloc");
        }
        bb.putInt(40);
        for (i = 0; i < 96; ++i) {
            bb.put((byte)0);
        }
        for (i = 0; i < 48; ++i) {
            bb.putShort((short)0);
        }
        bb.put((byte)2);
        bb.put((byte)2);
        bb.put((byte)0);
        bb.put((byte)0);
        bb.put((byte)0);
        bb.put((byte)0);
        bb.put((byte)0);
        bb.put((byte)0);
        bb.put((byte)0);
        bb.put((byte)0);
        bb.put((byte)0);
        bb.put((byte)0);
        bb.put((byte)0);
        bb.put((byte)0);
        bb.putShort((short)0);
        bb.putShort((short)0);
        if (bb.position() != 243) {
            throw new RuntimeException("Bad instrument H2 alloc (pos=" + bb.position() + ")");
        }
        bb.putInt(data.length * 2);
        bb.putInt(0);
        bb.putInt(0);
        bb.put((byte)64);
        bb.put((byte)0);
        bb.put((byte)16);
        bb.put((byte)-128);
        bb.put((byte)17);
        bb.put((byte)0);
        XMOut.putTextInBB(bb, "Percussion", 22);
        if (bb.position() != 283) {
            throw new RuntimeException("Bad instrument SH alloc");
        }
        short running = 0;
        for (int i2 = 0; i2 < data.length; ++i2) {
            short smp = data[i2];
            bb.putShort((short)(smp - running));
            running = smp;
        }
        if (bb.position() != bb.capacity()) {
            throw new RuntimeException("Bad instrument percussion alloc " + bb.position());
        }
        os.write(bb.array());
    }

    public static class Point {
        public short x;
        public short y;

        public Point(short tx, short ty) {
            this.x = tx;
            this.y = ty;
        }
    }
}

