/*
 * Decompiled with CFR 0.152.
 */
package libpiyo.export;

import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import libpiyo.PiyoPiyoWaveTrack;
import libpiyo.export.XMInstrumentOut;

public class XMInstrumentConversion {
    public static final long ENVLEN_RATIO_MUL = 10L;
    public static final long ENVLEN_RATIO_DIV = 8000L;
    public static final long ENVLEN_SRC_DIV = 64L;
    public static final long ENVLEN_BPM2BPS_DIV = 60L;
    public static final long ENVLEN_ALL_DIV = 30720000L;

    public static LinkedList<XMInstrumentOut.Point> convIPoints(PiyoPiyoWaveTrack wt, int bpm) {
        LinkedList<XMInstrumentOut.Point> points = new LinkedList<XMInstrumentOut.Point>();
        long baseMultiplier = 10L * (long)bpm * (long)wt.length;
        int lastX = 0;
        for (int envPos = 0; envPos < wt.envelope.length; ++envPos) {
            long epm = (long)envPos * baseMultiplier;
            short x = (short)(epm / 30720000L);
            short y = (short)(wt.envelope[envPos] >> 1);
            points.add(new XMInstrumentOut.Point(x, y));
            lastX = x;
        }
        points.add(new XMInstrumentOut.Point((short)(lastX + 1), 0));
        return points;
    }

    public static void naiveStripIPoints(LinkedList<XMInstrumentOut.Point> points) {
        if (points.size() <= 12) {
            return;
        }
        LinkedList<XMInstrumentOut.Point> intermediate = new LinkedList<XMInstrumentOut.Point>();
        int im1 = points.size() - 2;
        int jump = im1 / 10;
        for (int i = 0; i <= im1 && intermediate.size() < 11; i += jump) {
            intermediate.add(points.get(i));
        }
        intermediate.add(points.getLast());
        points.clear();
        points.addAll(intermediate);
    }

    public static void complexStripIPoints(LinkedList<XMInstrumentOut.Point> points) {
        int pointCount;
        if (points.size() <= 12) {
            return;
        }
        short[] originalProfile = XMInstrumentConversion.emulatePoints(points);
        while ((pointCount = points.size()) > 12) {
            int bestRemovalIndex = 1;
            long bestRemovalError = Long.MAX_VALUE;
            for (int i = 1; i < pointCount - 1; ++i) {
                LinkedList<XMInstrumentOut.Point> attempt = new LinkedList<XMInstrumentOut.Point>(points);
                attempt.remove(i);
                long error = XMInstrumentConversion.errorMetric(originalProfile, XMInstrumentConversion.emulatePoints(attempt));
                if (error >= bestRemovalError) continue;
                bestRemovalIndex = i;
                bestRemovalError = error;
            }
            points.remove(bestRemovalIndex);
        }
    }

    public static long errorMetric(short[] a, short[] b) {
        long total = 0L;
        for (int i = 0; i < a.length; ++i) {
            long va = a[i];
            long vb = b[i];
            long vc = va - vb;
            if (vc < 0L) {
                vc = -vc;
            }
            total += vc;
        }
        return total;
    }

    public static short[] emulatePoints(LinkedList<XMInstrumentOut.Point> points) {
        int i;
        short[] sim = new short[65536];
        if (points.size() == 0) {
            return sim;
        }
        XMInstrumentOut.Point pointA = points.get(0);
        if (points.size() != 1) {
            int pointBIndex = 1;
            XMInstrumentOut.Point pointB = points.get(1);
            for (i = 0; i < sim.length; ++i) {
                if (pointB.x == i) {
                    pointA = pointB;
                    if (++pointBIndex == points.size()) break;
                    pointB = points.get(pointBIndex);
                }
                int relative = i - pointA.x;
                int relativeLen = pointB.x - pointA.x;
                if (relative < 0) {
                    relative = 0;
                }
                if (relative > relativeLen) {
                    relative = relativeLen;
                }
                int relativeInv = relativeLen - relative;
                sim[i] = (short)((pointA.y * relativeInv + pointB.y * relative) / relativeLen);
            }
        }
        while (i < sim.length) {
            sim[i] = pointA.y;
            ++i;
        }
        return sim;
    }

    public static void rmOverlappingPoints(LinkedList<XMInstrumentOut.Point> points) {
        Collections.sort(points, new Comparator<XMInstrumentOut.Point>(){

            @Override
            public int compare(XMInstrumentOut.Point o1, XMInstrumentOut.Point o2) {
                if (o1.x < o2.x) {
                    return -1;
                }
                if (o1.x > o2.x) {
                    return 1;
                }
                return 0;
            }
        });
        short lastX = -1;
        for (int i = 0; i < points.size(); ++i) {
            short thisX = points.get((int)i).x;
            if (thisX > lastX) {
                lastX = thisX;
                continue;
            }
            points.remove(i);
            --i;
        }
    }
}

