/*
 * Decompiled with CFR 0.152.
 */
package libpiyo.export;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class XMCell {
    public byte note;
    public byte instrument;
    public byte volume;
    public byte effect;
    public byte effectParam;

    public void clear() {
        this.note = 0;
        this.instrument = 0;
        this.volume = 0;
        this.effect = 0;
        this.effectParam = 0;
    }

    public boolean isClear() {
        if (this.note != 0) {
            return false;
        }
        if (this.instrument != 0) {
            return false;
        }
        if (this.volume != 0) {
            return false;
        }
        if (this.effect != 0) {
            return false;
        }
        return this.effectParam == 0;
    }

    public static void putPattern(OutputStream os, XMCell[] cells, int channels) throws IOException {
        ByteBuffer patternBuf = ByteBuffer.allocate(9 + cells.length * 5);
        patternBuf.order(ByteOrder.LITTLE_ENDIAN);
        patternBuf.putInt(9);
        patternBuf.put((byte)0);
        patternBuf.putShort((short)(cells.length / channels));
        patternBuf.putShort((short)0);
        int packedLen = 0;
        for (int j = 0; j < cells.length; ++j) {
            XMCell cell = cells[j];
            if (cell.isClear()) {
                patternBuf.put((byte)-128);
                ++packedLen;
                continue;
            }
            patternBuf.put(cell.note);
            patternBuf.put(cell.instrument);
            patternBuf.put(cell.volume);
            patternBuf.put(cell.effect);
            patternBuf.put(cell.effectParam);
            packedLen += 5;
        }
        patternBuf.putShort(7, (short)packedLen);
        os.write(patternBuf.array(), 0, patternBuf.position());
    }
}

