/*
 * Decompiled with CFR 0.152.
 */
package libpiyo.export;

import gabien.media.audio.AudioIOCRSet;
import gabien.media.audio.AudioIOFormat;
import gabien.media.audio.AudioIOSource;
import gabien.media.audio.fileio.WavIO;
import java.io.IOException;
import java.io.OutputStream;
import libpiyo.PiyoPiyoFile;
import libpiyo.PiyoPiyoPlayer;
import libpiyo.SimpleMixer;

public class WavOut {
    public static void perform(OutputStream fos, PiyoPiyoFile coreFile, int startFrame, int ignoreFrame, int frameCount) throws IOException {
        final SimpleMixer sm = new SimpleMixer(96, 2);
        final PiyoPiyoPlayer iPlayer = new PiyoPiyoPlayer(coreFile, sm, 0);
        int sampleRate = sm.sampleRate;
        final double time = 1.0 / (double)sampleRate;
        iPlayer.pitchScale = 22050.0f / (float)sampleRate;
        iPlayer.setCurrentFrame(startFrame);
        int ignoreSampleCount = (int)((double)(ignoreFrame * sampleRate) * iPlayer.piyoFile.beatTime());
        final int sampleFrameCount = (int)((double)(frameCount * sampleRate) * iPlayer.piyoFile.beatTime());
        int maxSkipTimestep = 32;
        short[] tmpInterleaved = new short[maxSkipTimestep * 2];
        for (int i = 0; i < ignoreSampleCount; i += maxSkipTimestep) {
            iPlayer.updateBeats(time * (double)maxSkipTimestep);
            sm.pullData(tmpInterleaved, 0, Math.min(ignoreSampleCount - i, maxSkipTimestep));
        }
        WavIO.writeWAV(fos, new AudioIOSource.SourceS16(new AudioIOCRSet(2, sampleRate)){

            @Override
            public int frameCount() {
                return sampleFrameCount;
            }

            @Override
            public void nextFrames(short[] buffer, int at, int frames) {
                while (frames > 0) {
                    iPlayer.updateBeats(time);
                    sm.pullData(buffer, at, 1);
                    at += 2;
                    --frames;
                }
            }
        }, AudioIOFormat.F_S16);
    }
}

