/*
 * Decompiled with CFR 0.152.
 */
package libpiyo.export;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import libpiyo.PiyoPiyoFile;
import libpiyo.PiyoPiyoFrame;

public class MidOut {
    public static void perform(OutputStream fos, PiyoPiyoFile ppf) throws IOException {
        int i;
        DataOutputStream dos = new DataOutputStream(fos);
        fos.write(77);
        fos.write(84);
        fos.write(104);
        fos.write(100);
        dos.writeInt(6);
        dos.writeShort(0);
        dos.writeShort(1);
        int dtPB = 500;
        int uspb = 500000;
        if (Parameter.MSCOMPAT.value == 1) {
            uspb = ppf.musicWait * 1000;
            dtPB = ppf.musicWait;
        }
        double dtPMS = (double)dtPB / ((double)uspb / 1000.0);
        int deltaTimeMusicWait = (int)(dtPMS * (double)ppf.musicWait);
        System.err.println("DTMW " + deltaTimeMusicWait + " at " + uspb + "uspb/" + dtPB + "dtpb/" + dtPMS + " calced dtPMS");
        dos.writeShort(dtPB);
        fos.write(77);
        fos.write(84);
        fos.write(114);
        fos.write(107);
        ByteArrayOutputStream track = new ByteArrayOutputStream();
        MidOut.writeVLI(track, 0);
        track.write(255);
        track.write(88);
        track.write(4);
        track.write(4);
        track.write(2);
        track.write(24);
        track.write(8);
        MidOut.writeVLI(track, 0);
        track.write(255);
        track.write(81);
        track.write(3);
        track.write(uspb >> 16);
        track.write(uspb >> 8);
        track.write(uspb);
        int[] channels = new int[]{Parameter.A_C1.value, Parameter.A_C2.value, Parameter.A_C3.value, 9};
        int[] programs = new int[]{Parameter.P_C1.value, Parameter.P_C2.value, Parameter.P_C3.value};
        int[] volumes = new int[]{Parameter.V_C1.value, Parameter.V_C2.value, Parameter.V_C3.value, Parameter.V_CP.value};
        for (int i2 = 0; i2 < 4; ++i2) {
            if (i2 != 3) {
                MidOut.writeVLI(track, 0);
                track.write(192 + i2);
                track.write(programs[i2]);
            }
            MidOut.writeVLI(track, 0);
            track.write(176 + channels[i2]);
            track.write(7);
            track.write(volumes[i2]);
        }
        int[] balanceTranslator = new int[]{0, 0, 21, 42, 64, 86, 107, 127};
        LinkedList<MidiEvent> midiEvents = new LinkedList<MidiEvent>();
        MidiEvent[] triggerNoteOff = new MidiEvent[96];
        int startF = 0;
        int endF = ppf.getFrameCount();
        boolean cutting = false;
        boolean continuous = false;
        if (Parameter.MODE.value == 0) {
            startF = 0;
            endF = ppf.loopEnd;
            cutting = true;
        } else if (Parameter.MODE.value == 1) {
            startF = ppf.loopStart;
            endF = ppf.loopEnd;
            continuous = true;
            cutting = true;
        } else if (Parameter.MODE.value == 2) {
            // empty if block
        }
        for (int i3 = startF; i3 < endF; ++i3) {
            int currTimeFrame = (i3 - startF) * deltaTimeMusicWait;
            for (int channelNo = 0; channelNo < 4; ++channelNo) {
                PiyoPiyoFrame frame = ppf.getFrameOrNull(i3, channelNo);
                if (frame == null) continue;
                if (frame.panValue != 0) {
                    midiEvents.add(MidiEvent.pan(currTimeFrame, channels[channelNo], balanceTranslator[frame.panValue]));
                }
                for (int j = 0; j < frame.hitNotes.length; ++j) {
                    int tnoIndex = j + channelNo * 24;
                    int mappedNote = -1;
                    int envelopeDT = deltaTimeMusicWait / 2;
                    if (channelNo < 3) {
                        int ets = 500;
                        int no = 24;
                        if (channelNo == 0) {
                            ets = Parameter.E_C1.value;
                            no = Parameter.D_C1.value;
                        } else if (channelNo == 1) {
                            ets = Parameter.E_C2.value;
                            no = Parameter.D_C2.value;
                        } else if (channelNo == 2) {
                            ets = Parameter.E_C3.value;
                            no = Parameter.D_C3.value;
                        }
                        mappedNote = no + ppf.waveTracks[channelNo].octave * Parameter.EOW.value + j;
                        envelopeDT = (int)((double)ppf.waveTracks[channelNo].length / 22050.0 * dtPMS * (double)ets);
                        if (envelopeDT < 1) {
                            envelopeDT = 1;
                        }
                    } else {
                        int[] mapping = new int[]{Parameter._DS0.value, Parameter._DS0.value, Parameter._DS2.value, Parameter._DS2.value, Parameter._DS4.value, Parameter._DS4.value, -1, -1, Parameter._DS6.value, Parameter._DS6.value, Parameter._DS8.value, Parameter._DS8.value, Parameter._DSA.value, Parameter._DSA.value, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
                        mappedNote = mapping[j];
                    }
                    if (mappedNote == -1 || !frame.hitNotes[j]) continue;
                    if (triggerNoteOff[tnoIndex] != null) {
                        triggerNoteOff[tnoIndex].exactTime = Math.min(triggerNoteOff[tnoIndex].exactTime, currTimeFrame);
                    }
                    int velocity = 64;
                    if (channelNo == 3) {
                        velocity = (j & 1) == 0 ? Parameter.V_PA.value : Parameter.V_PB.value;
                    }
                    midiEvents.add(MidiEvent.note(currTimeFrame, channels[channelNo], mappedNote, true, velocity));
                    triggerNoteOff[tnoIndex] = MidiEvent.note(currTimeFrame + envelopeDT, channels[channelNo], mappedNote, false, 64);
                    midiEvents.add(triggerNoteOff[tnoIndex]);
                }
            }
        }
        int endTime = (endF - startF) * deltaTimeMusicWait;
        midiEvents.add(MidiEvent.end(endTime));
        if (cutting) {
            if (continuous) {
                for (MidiEvent me : midiEvents) {
                    if (me.subOrder == 3) continue;
                    if (me.subOrder == 0) {
                        me.subOrder = -1;
                    }
                    me.exactTime %= endTime;
                }
            } else {
                for (MidiEvent me : new LinkedList(midiEvents)) {
                    if (me.exactTime <= endTime) continue;
                    midiEvents.remove(me);
                }
            }
        }
        int[] usedNoteMap = new int[2048];
        for (i = 0; i < usedNoteMap.length; ++i) {
            usedNoteMap[i] = -1;
        }
        for (i = 0; i < 2; ++i) {
            Collections.sort(midiEvents, new Comparator<MidiEvent>(){

                @Override
                public int compare(MidiEvent midiEvent, MidiEvent t1) {
                    if (midiEvent.exactTime < t1.exactTime) {
                        return -1;
                    }
                    if (midiEvent.exactTime > t1.exactTime) {
                        return 1;
                    }
                    if (midiEvent.subOrder < t1.subOrder) {
                        return -1;
                    }
                    if (midiEvent.subOrder > t1.subOrder) {
                        return 1;
                    }
                    return 0;
                }
            });
            for (MidiEvent me : midiEvents) {
                int unn;
                if ((me.subOrder == 0 || me.subOrder == 2) && (unn = usedNoteMap[me.getCNI()]) == -1) {
                    usedNoteMap[me.getCNI()] = me.exactTime;
                }
                if (me.subOrder != -1 || (unn = usedNoteMap[me.getCNI()]) == -1) continue;
                me.exactTime = Math.min(unn, me.exactTime);
            }
        }
        int writerTime = 0;
        for (MidiEvent me : midiEvents) {
            MidOut.writeVLI(track, me.exactTime - writerTime);
            writerTime = me.exactTime;
            track.write(me.data);
        }
        dos.writeInt(track.size());
        track.writeTo(fos);
    }

    private static void writeVLI(OutputStream fos, int i) throws IOException {
        if (i >= 0x200000) {
            fos.write(0x80 | i >> 21 & 0x7F);
        }
        if (i >= 16384) {
            fos.write(0x80 | i >> 14 & 0x7F);
        }
        if (i >= 128) {
            fos.write(0x80 | i >> 7 & 0x7F);
        }
        fos.write(i & 0x7F);
    }

    public static void setup(String text) {
        if (text.toLowerCase().endsWith("tidepool.pmd")) {
            Parameter.P_C1.value = 0;
            Parameter.P_C2.value = 7;
            Parameter.P_C3.value = 38;
        } else if (text.toLowerCase().endsWith("ikachan.pmd")) {
            Parameter.P_C1.value = 38;
            Parameter.P_C2.value = 0;
            Parameter.P_C3.value = 38;
        }
    }

    public static class MidiEvent {
        public int exactTime;
        public byte[] data;
        public int subOrder = 0;

        public static MidiEvent note(int time, int channel, int note, boolean on, int velocity) {
            MidiEvent me = new MidiEvent();
            me.exactTime = time;
            me.subOrder = on ? 2 : 0;
            me.data = new byte[]{(byte)(128 + channel + (on ? 16 : 0)), (byte)note, (byte)velocity};
            return me;
        }

        public static MidiEvent pan(int time, int channel, int pan) {
            MidiEvent me = new MidiEvent();
            me.exactTime = time;
            me.subOrder = 1;
            me.data = new byte[]{(byte)(176 + channel), 8, (byte)pan};
            return me;
        }

        public static MidiEvent end(int time) {
            MidiEvent me = new MidiEvent();
            me.exactTime = time;
            me.subOrder = 3;
            me.data = new byte[]{-1, 47, 0};
            return me;
        }

        public int getCNI() {
            return this.data[0] & 0xF | this.data[1] << 4;
        }
    }

    public static enum Parameter {
        A_C1(0, 0, 15, "Channel 1 MIDIChannel", true),
        P_C1(0, 0, 127, "Channel 1 Program", true),
        E_C1(1, 500, 2000, "Channel 1 EnvTimeScale", true),
        V_C1(0, 127, 127, "Channel 1 Volume", true),
        D_C1(0, 24, 127, "Channel 1 Note Offset", true),
        A_C2(0, 1, 15, "Channel 2 MIDIChannel", true),
        P_C2(0, 0, 127, "Channel 2 Program", true),
        E_C2(1, 1000, 2000, "Channel 2 EnvTimeScale", true),
        V_C2(0, 127, 127, "Channel 2 Volume", true),
        D_C2(0, 24, 127, "Channel 2 Note Offset", true),
        A_C3(0, 2, 15, "Channel 3 MIDIChannel", true),
        P_C3(0, 0, 127, "Channel 3 Program", true),
        E_C3(1, 500, 2000, "Channel 3 EnvTimeScale", true),
        V_C3(0, 127, 127, "Channel 3 Volume", true),
        D_C3(0, 24, 127, "Channel 3 Note Offset", true),
        V_CP(0, 127, 127, "Channel P Volume", false),
        V_PA(0, 64, 127, "Channel P! Velocity", false),
        V_PB(0, 32, 127, "Channel P. Velocity", false),
        _DS0(0, 35, 127, "X1 Note", false),
        _DS2(0, 36, 127, "X2 Note", false),
        _DS4(0, 39, 127, "X3 Note", false),
        _DS6(0, 54, 127, "HH Note", false),
        _DS8(0, 33, 127, "Cl Note", false),
        _DSA(0, 44, 127, "Cs Note", false),
        EOW(0, 12, 127, "Effective Octave Size", false),
        MODE(0, 2, 2, "Cut Mode\n0: Intro\n1: Loop\n2: All", false),
        MSCOMPAT(0, 0, 1, "MuseScore Compat.\n1 to enable", false);

        public final int min;
        public final int max;
        public final String text;
        public final boolean left;
        public int value;

        private Parameter(int i, int i1, int i2, String s, boolean l) {
            this.left = l;
            this.min = i;
            this.value = i1;
            this.max = i2;
            this.text = s;
        }
    }
}

