/*
 * Decompiled with CFR 0.152.
 */
package libpiyo;

import gabien.uslx.append.MathsX;
import org.eclipse.jdt.annotation.NonNull;

public class SimpleMixer {
    public static final int CANONICAL_SAMPLE_RATE = 22050;
    private static final int[] VOLCONV = new int[301];
    public final boolean[] active;
    public final short[][] sound;
    public final int[] pos;
    public final int[] volume;
    public final int[] pan;
    public int totalVolumeState;
    public final int sampleRate;
    public final int sampleRateMul;
    public final int decayFracMul;

    public SimpleMixer(int channelCount, int sampleRateMul) {
        this.sampleRate = 22050 * sampleRateMul;
        this.sampleRateMul = sampleRateMul;
        this.decayFracMul = sampleRateMul * 256;
        this.active = new boolean[channelCount];
        this.sound = new short[channelCount][];
        this.pos = new int[channelCount];
        this.volume = new int[channelCount];
        this.pan = new int[channelCount];
    }

    public void pullData(@NonNull short[] interleaved, int ofs, int frames) {
        int lim = ofs + frames * 2;
        for (int i = ofs; i < lim; i += 2) {
            int totalL = 0;
            int totalR = 0;
            int totalVolume = 0;
            for (int j = 0; j < this.active.length; ++j) {
                if (!this.active[j]) continue;
                int cPos = this.pos[j];
                short[] cSnd = this.sound[j];
                if (cPos >= cSnd.length) {
                    this.active[j] = false;
                    continue;
                }
                short sample = cSnd[cPos];
                this.pos[j] = cPos + 1;
                int cVol = VOLCONV[MathsX.clamp(this.volume[j], 0, 300)];
                totalVolume += cVol;
                int cPan = MathsX.clamp(this.pan[j], -256, 256);
                cPan = cPan * 3 / 2;
                int cPanInv = -cPan;
                int panL = cPan <= 0 ? 256 : 256 - cPan;
                int panR = cPanInv <= 0 ? 256 : 256 - cPanInv;
                int pannedL = sample * panL >> 8;
                int pannedR = sample * panR >> 8;
                totalL += pannedL * cVol;
                totalR += pannedR * cVol;
            }
            if (totalVolume < 256) {
                totalVolume = 256;
            }
            this.totalVolumeState = Math.max(this.totalVolumeState - 1, totalVolume * this.decayFracMul);
            int totalVolumeRelaxed = this.totalVolumeState / this.decayFracMul;
            totalL *= 3;
            totalR *= 3;
            interleaved[i] = (short)MathsX.clamp(totalL /= totalVolumeRelaxed, Short.MIN_VALUE, Short.MAX_VALUE);
            interleaved[i + 1] = (short)MathsX.clamp(totalR /= totalVolumeRelaxed, Short.MIN_VALUE, Short.MAX_VALUE);
        }
    }

    static {
        for (int i = 0; i <= 300; ++i) {
            float f = (float)i / 600.0f + 0.5f;
            f *= f;
            SimpleMixer.VOLCONV[i] = (int)(f *= 256.0f);
        }
    }
}

