/*
 * Decompiled with CFR 0.152.
 */
package libpiyo;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import libpiyo.PiyoPiyoFile;

public class PiyoPiyoWaveTrack {
    public int[] waveForm = new int[256];
    public int[] envelope = new int[64];
    public int volume;
    public int length;
    public int octave;
    public int icon;

    public PiyoPiyoWaveTrack(int tt) {
        this.reset(tt);
    }

    public void copyFrom(PiyoPiyoWaveTrack waveTrack) {
        int i;
        for (i = 0; i < this.waveForm.length; ++i) {
            this.waveForm[i] = waveTrack.waveForm[i];
        }
        for (i = 0; i < this.envelope.length; ++i) {
            this.envelope[i] = waveTrack.envelope[i];
        }
        this.octave = waveTrack.octave;
        this.icon = waveTrack.icon;
        this.length = waveTrack.length;
        this.volume = waveTrack.volume;
    }

    public void reset(int trackType) {
        int i;
        if (trackType == 0) {
            for (i = 0; i < this.waveForm.length / 2; ++i) {
                this.waveForm[i] = 96;
                this.waveForm[i + 128] = 192;
            }
        } else if (trackType == 1) {
            for (i = 0; i < this.waveForm.length / 2; ++i) {
                this.waveForm[i] = i;
                this.waveForm[i + 128] = 255 - i;
            }
        } else {
            for (i = 0; i < this.waveForm.length; ++i) {
                int sineMod = (int)(Math.sin((double)i / (double)this.waveForm.length * 2.0 * Math.PI) * 99.9999);
                this.waveForm[i] = 128 + sineMod ^ 0x80;
            }
        }
        for (i = 0; i < this.envelope.length; ++i) {
            this.envelope[i] = 0;
        }
        for (i = 0; i < this.envelope.length / 2; ++i) {
            this.envelope[i] = 127;
        }
        int[] oldEnv = new int[this.envelope.length];
        for (int i2 = 0; i2 < 64; ++i2) {
            System.arraycopy(this.envelope, 0, oldEnv, 0, this.envelope.length);
            for (int j = 1; j < this.envelope.length - 1; ++j) {
                this.envelope[j] = (oldEnv[j - 1] + oldEnv[j] + oldEnv[j + 1]) / 3;
                if (j <= 16) continue;
                int n = j;
                this.envelope[n] = this.envelope[n] + oldEnv[j - 16] / 2;
                int n2 = j;
                this.envelope[n2] = this.envelope[n2] / 2;
            }
        }
        this.octave = 1;
        this.icon = 0;
        this.length = 11000;
        this.volume = 250;
    }

    public void read(InputStream is) throws IOException {
        this.octave = PiyoPiyoFile.read8(is);
        this.icon = PiyoPiyoFile.read8(is);
        PiyoPiyoFile.read8(is);
        PiyoPiyoFile.read8(is);
        this.length = PiyoPiyoFile.read32(is);
        this.volume = PiyoPiyoFile.read32(is);
        PiyoPiyoFile.read32(is);
        PiyoPiyoFile.read32(is);
        PiyoPiyoFile.readArray(is, this.waveForm);
        PiyoPiyoFile.readArray(is, this.envelope);
    }

    public void write(OutputStream os) throws IOException {
        os.write(this.octave);
        os.write(this.icon);
        os.write(0);
        os.write(0);
        PiyoPiyoFile.write32(os, this.length);
        PiyoPiyoFile.write32(os, this.volume);
        PiyoPiyoFile.write32(os, 0);
        PiyoPiyoFile.write32(os, 0);
        PiyoPiyoFile.writeArray(os, this.waveForm);
        PiyoPiyoFile.writeArray(os, this.envelope);
    }

    public short[] generateSample(int note, int sampleRateMul) {
        int sampleRate = 22050 * sampleRateMul;
        int octaveAdj = this.octave & 0x1F;
        short[] data = new short[this.length * sampleRateMul];
        int advanceFP = (int)(8363.0 * Math.pow(2.0, (float)(note += octaveAdj * 12) / 12.0f) / (double)sampleRate * 256.0);
        int waveformPosFP = 0;
        for (int i = 0; i < data.length; ++i) {
            int envPos = i * 64 / data.length;
            int wfpInt = waveformPosFP >> 8;
            int val = (this.waveForm[wfpInt % this.waveForm.length] & 0xFF ^ 0x80) - 128;
            data[i] = (short)(val *= this.envelope[envPos] * 2);
            waveformPosFP += advanceFP;
        }
        return data;
    }
}

