/*
 * Decompiled with CFR 0.152.
 */
package libpiyo;

import gabien.GaBIEn;
import gabien.media.audio.AudioIOCRSet;
import gabien.media.audio.AudioIOFormat;
import gabien.media.audio.AudioIOSample;
import gabien.media.audio.AudioIOSource;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class PiyoPiyoPlayingSample {
    public static int[] drumTable = new int[]{0, 1, 4, -1, 2, 3, 5, -1, -1, -1, -1, -1};
    public static short[][] samples = new short[6][];

    public static void ensureAllSamplesLoaded() throws IOException {
        InputStream is = GaBIEn.getInFile("piyoDrums.bin");
        if (is == null) {
            throw new IOException("Couldn't open piyoDrums.bin");
        }
        DataInputStream dis = new DataInputStream(is);
        for (int drumSample = 0; drumSample < 6; ++drumSample) {
            short[] sample = new short[dis.readInt() / 2];
            int i = 0;
            while (i < sample.length) {
                int l = dis.read();
                sample[i] = (short)(dis.read() << 8);
                int n = i++;
                sample[n] = (short)(sample[n] | l);
            }
            PiyoPiyoPlayingSample.samples[drumSample] = sample;
        }
        is.close();
    }

    public static short[] getSample(int pos, int sampleRateMul) {
        int drumSample = drumTable[pos / 2];
        if (drumSample == -1) {
            return new short[1];
        }
        if (samples[drumSample] == null) {
            return new short[1];
        }
        final short[] origSample = samples[drumSample];
        if (sampleRateMul != 1) {
            AudioIOSample smp;
            try {
                smp = new AudioIOSample(new AudioIOSource.SourceS16(new AudioIOCRSet(1, 22050)){
                    int idx;
                    {
                        super(arg0);
                        this.idx = 0;
                    }

                    @Override
                    public int frameCount() {
                        return origSample.length;
                    }

                    @Override
                    public void nextFrames(short[] buffer, int at, int frames) {
                        for (int i = 0; i < frames; ++i) {
                            buffer[at++] = origSample[this.idx++];
                        }
                    }
                }, AudioIOFormat.F_S16);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            smp = smp.resample(new AudioIOCRSet(1, 22050 * sampleRateMul), false);
            short[] newSample = new short[smp.length];
            int[] tmp = new int[1];
            for (int i = 0; i < newSample.length; ++i) {
                smp.getS32(i, tmp);
                newSample[i] = (short)(tmp[0] >> 16);
            }
            return newSample;
        }
        return origSample;
    }
}

