/*
 * Decompiled with CFR 0.152.
 */
package libpiyo;

import java.io.IOException;
import java.io.InputStream;
import libpiyo.PiyoPiyoFile;
import libpiyo.PiyoPiyoFrame;
import libpiyo.PiyoPiyoPlayingSample;
import libpiyo.PiyoPiyoWaveTrack;
import libpiyo.SimpleMixer;
import org.eclipse.jdt.annotation.Nullable;

public class PiyoPiyoPlayer {
    public static final int SOUND_ID_COUNT = 96;
    public double withinBeatPosition = 0.0;
    public final PiyoPiyoFile piyoFile;
    public SimpleMixer sound;
    public int baseSoundId;
    public int currentFrame = 0;
    public boolean handleLoop = true;
    public float pitchScale = 1.0f;

    public PiyoPiyoPlayer(InputStream fis, SimpleMixer sound, int baseSoundId) throws IOException {
        this.sound = sound;
        this.baseSoundId = baseSoundId;
        this.piyoFile = new PiyoPiyoFile();
        this.piyoFile.loadFile(fis);
        this.resetSynth();
    }

    public PiyoPiyoPlayer(PiyoPiyoFile file, SimpleMixer sound, int baseSoundId) {
        this.sound = sound;
        this.baseSoundId = baseSoundId;
        this.piyoFile = file;
        this.resetSynth();
    }

    public void resetSynth() {
        for (int i = 0; i < 96; ++i) {
            this.sound.active[this.baseSoundId + i] = false;
            this.sound.pan[this.baseSoundId + i] = 0;
        }
        this.regenWaveforms();
    }

    public void regenWaveforms() {
        int soundId = this.baseSoundId;
        for (int trackId = 0; trackId < 4; ++trackId) {
            for (int note = 0; note < 24; ++note) {
                if (trackId == 3) {
                    this.sound.sound[soundId] = PiyoPiyoPlayingSample.getSample(note, this.sound.sampleRateMul);
                    this.sound.volume[soundId] = (note & 1) == 0 ? this.piyoFile.drumVolume : this.piyoFile.drumVolume * 70 / 100;
                } else {
                    PiyoPiyoWaveTrack wt = this.piyoFile.waveTracks[trackId];
                    this.sound.sound[soundId] = wt.generateSample(note, this.sound.sampleRateMul);
                    this.sound.volume[soundId] = wt.volume;
                }
                ++soundId;
            }
        }
    }

    public void updateBeats(double deltaTime) {
        this.withinBeatPosition += deltaTime;
        double musicWaitTime = this.piyoFile.beatTime();
        while (this.withinBeatPosition < 0.0) {
            this.withinBeatPosition += musicWaitTime;
            for (int i = 0; i < 4; ++i) {
                this.handleBeat(this.piyoFile.getFrameOrNull(this.currentFrame, i), i);
            }
            --this.currentFrame;
            if (this.currentFrame >= 0) continue;
            this.setCurrentFrame(this.piyoFile.loopEnd);
        }
        int pfc = this.piyoFile.getFrameCount();
        while (this.withinBeatPosition > musicWaitTime) {
            this.withinBeatPosition -= musicWaitTime;
            for (int i = 0; i < 4; ++i) {
                this.handleBeat(this.piyoFile.getFrameOrNull(this.currentFrame, i), i);
            }
            ++this.currentFrame;
            if (this.currentFrame < pfc && (!this.handleLoop || this.currentFrame < this.piyoFile.loopEnd)) continue;
            this.setCurrentFrame(this.piyoFile.loopStart);
        }
    }

    public void setCurrentFrame(int value) {
        int pfc;
        this.currentFrame = value;
        if (this.currentFrame < 0) {
            this.currentFrame = 0;
        }
        if (this.currentFrame >= (pfc = this.piyoFile.getFrameCount())) {
            this.currentFrame = pfc - 1;
        }
        this.withinBeatPosition = 0.0;
    }

    private void handleBeat(@Nullable PiyoPiyoFrame piyoPiyoFrame, int track) {
        if (piyoPiyoFrame == null) {
            return;
        }
        if (piyoPiyoFrame.panValue != 0) {
            this.panTrack(track, piyoPiyoFrame.panValue);
        }
        for (int i = 0; i < 24; ++i) {
            if (!piyoPiyoFrame.hitNotes[i]) continue;
            this.playNote(track, i);
        }
    }

    public void playNote(int track, int i) {
        int soundId = this.baseSoundId + track * 24 + i;
        this.sound.active[soundId] = true;
        this.sound.pos[soundId] = 0;
    }

    public void panTrack(int track, int ppPanValue) {
        int panValue = 0;
        if (ppPanValue == 1) {
            panValue = -160;
        }
        if (ppPanValue == 2) {
            panValue = -76;
        }
        if (ppPanValue == 3) {
            panValue = -32;
        }
        if (ppPanValue == 5) {
            panValue = 32;
        }
        if (ppPanValue == 6) {
            panValue = 76;
        }
        if (ppPanValue == 7) {
            panValue = 164;
        }
        int soundId = this.baseSoundId + track * 24;
        for (int i = 0; i < 24; ++i) {
            this.sound.pan[soundId++] = panValue;
        }
    }
}

