/*
 * Decompiled with CFR 0.152.
 */
package libpiyo;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import libpiyo.PiyoPiyoFile;

public class PiyoPiyoFrame {
    public boolean[] hitNotes = new boolean[24];
    public int panValue;

    public PiyoPiyoFrame() {
    }

    public PiyoPiyoFrame(PiyoPiyoFrame other) {
        for (int i = 0; i < this.hitNotes.length; ++i) {
            this.hitNotes[i] = other.hitNotes[i];
        }
        this.panValue = other.panValue;
    }

    public void read(InputStream is) throws IOException {
        this.decodeBitfield(PiyoPiyoFile.read8(is), 0);
        this.decodeBitfield(PiyoPiyoFile.read8(is), 8);
        this.decodeBitfield(PiyoPiyoFile.read8(is), 16);
        this.panValue = PiyoPiyoFile.read8(is);
    }

    private void decodeBitfield(int read8, int i) {
        int v = 1;
        for (int b = 0; b < 8; ++b) {
            this.hitNotes[b + i] = (read8 & v) != 0;
            v <<= 1;
        }
    }

    private int encodeBitfield(int i) {
        int v = 1;
        int r = 0;
        for (int b = 0; b < 8; ++b) {
            if (this.hitNotes[b + i]) {
                r |= v;
            }
            v <<= 1;
        }
        return r;
    }

    public void write(OutputStream os) throws IOException {
        os.write(this.encodeBitfield(0));
        os.write(this.encodeBitfield(8));
        os.write(this.encodeBitfield(16));
        os.write(this.panValue);
    }

    public boolean isEmpty() {
        for (int b = 0; b < this.hitNotes.length; ++b) {
            if (!this.hitNotes[b]) continue;
            return false;
        }
        return this.panValue == 0;
    }

    public void merge(PiyoPiyoFrame musicFrame) {
        for (int b = 0; b < 24; ++b) {
            int n = b;
            this.hitNotes[n] = this.hitNotes[n] | musicFrame.hitNotes[b];
        }
        if (musicFrame.panValue != 0) {
            this.panValue = musicFrame.panValue;
        }
    }
}

