/*
 * Decompiled with CFR 0.152.
 */
package libpiyo;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import libpiyo.PiyoPiyoFrame;
import libpiyo.PiyoPiyoWaveTrack;
import org.eclipse.jdt.annotation.Nullable;

public final class PiyoPiyoFile {
    public final PiyoPiyoWaveTrack[] waveTracks = new PiyoPiyoWaveTrack[3];
    public int musicWait;
    public int drumVolume;
    public int loopStart;
    public int loopEnd;
    private PiyoPiyoFrame[] musicFrames;

    public PiyoPiyoFile() {
        this.waveTracks[0] = new PiyoPiyoWaveTrack(0);
        this.waveTracks[1] = new PiyoPiyoWaveTrack(1);
        this.waveTracks[2] = new PiyoPiyoWaveTrack(2);
        this.reset();
    }

    public PiyoPiyoFile(PiyoPiyoFile other) {
        this();
        this.copyFrom(other);
    }

    public synchronized void copyFrom(PiyoPiyoFile other) {
        this.waveTracks[0].copyFrom(other.waveTracks[0]);
        this.waveTracks[1].copyFrom(other.waveTracks[1]);
        this.waveTracks[2].copyFrom(other.waveTracks[2]);
        this.musicWait = other.musicWait;
        this.drumVolume = other.drumVolume;
        this.loopStart = other.loopStart;
        this.loopEnd = other.loopEnd;
        this.musicFrames = new PiyoPiyoFrame[other.musicFrames.length];
        for (int i = 0; i < this.musicFrames.length; ++i) {
            this.musicFrames[i] = new PiyoPiyoFrame(other.musicFrames[i]);
        }
    }

    public synchronized void resize(int targetLength) {
        PiyoPiyoFrame[] oldMusicFrames = this.musicFrames;
        PiyoPiyoFrame[] newMusicFrames = new PiyoPiyoFrame[targetLength * 4];
        int omfSection = oldMusicFrames.length / 4;
        int nmfSection = targetLength;
        for (int i = 0; i < targetLength; ++i) {
            if (i < omfSection) {
                newMusicFrames[i] = oldMusicFrames[i];
                newMusicFrames[i + nmfSection] = oldMusicFrames[i + omfSection];
                newMusicFrames[i + nmfSection * 2] = oldMusicFrames[i + omfSection * 2];
                newMusicFrames[i + nmfSection * 3] = oldMusicFrames[i + omfSection * 3];
                continue;
            }
            newMusicFrames[i] = new PiyoPiyoFrame();
            newMusicFrames[i + nmfSection] = new PiyoPiyoFrame();
            newMusicFrames[i + nmfSection * 2] = new PiyoPiyoFrame();
            newMusicFrames[i + nmfSection * 3] = new PiyoPiyoFrame();
        }
        this.musicFrames = newMusicFrames;
    }

    public int getFrameCount() {
        return this.musicFrames.length / 4;
    }

    @Nullable
    public PiyoPiyoFrame getFrameOrNull(int at, int channel) {
        int fd4 = this.musicFrames.length / 4;
        PiyoPiyoFrame[] cmf = this.musicFrames;
        if (at < 0) {
            return null;
        }
        if (at >= fd4) {
            return null;
        }
        return cmf[at + fd4 * channel];
    }

    public double beatTime() {
        return Math.max((double)this.musicWait / 1000.0, 0.001);
    }

    public synchronized void reset() {
        int i;
        this.musicWait = 130;
        this.loopStart = 0;
        this.loopEnd = 0;
        int musicLength = 128;
        this.musicFrames = new PiyoPiyoFrame[musicLength * 4];
        for (i = 0; i < this.waveTracks.length; ++i) {
            this.waveTracks[i].reset(i);
        }
        this.drumVolume = 300;
        for (i = 0; i < this.musicFrames.length; ++i) {
            this.musicFrames[i] = new PiyoPiyoFrame();
        }
    }

    public synchronized void loadFile(InputStream is) throws IOException {
        if (PiyoPiyoFile.read8(is) != 80 || PiyoPiyoFile.read8(is) != 77 || PiyoPiyoFile.read8(is) != 68) {
            throw new IOException("Not a PMD file!");
        }
        PiyoPiyoFile.read8(is);
        int pos = PiyoPiyoFile.read32(is) - 1048;
        this.musicWait = PiyoPiyoFile.read32(is);
        this.loopStart = PiyoPiyoFile.read32(is);
        this.loopEnd = PiyoPiyoFile.read32(is);
        this.musicFrames = new PiyoPiyoFrame[PiyoPiyoFile.read32(is) * 4];
        this.waveTracks[0].read(is);
        this.waveTracks[1].read(is);
        this.waveTracks[2].read(is);
        this.drumVolume = PiyoPiyoFile.read32(is);
        is.skip(pos);
        for (int i = 0; i < this.musicFrames.length; ++i) {
            this.musicFrames[i] = new PiyoPiyoFrame();
            this.musicFrames[i].read(is);
        }
    }

    public void saveFile(OutputStream os) throws IOException {
        os.write(80);
        os.write(77);
        os.write(68);
        os.write(128);
        PiyoPiyoFile.write32(os, 1048);
        PiyoPiyoFile.write32(os, this.musicWait);
        PiyoPiyoFile.write32(os, this.loopStart);
        PiyoPiyoFile.write32(os, this.loopEnd);
        PiyoPiyoFile.write32(os, this.musicFrames.length / 4);
        this.waveTracks[0].write(os);
        this.waveTracks[1].write(os);
        this.waveTracks[2].write(os);
        PiyoPiyoFile.write32(os, this.drumVolume);
        for (int i = 0; i < this.musicFrames.length; ++i) {
            this.musicFrames[i].write(os);
        }
    }

    protected static int read8(InputStream is) throws IOException {
        int i = is.read();
        if (i == -1) {
            throw new IOException("Unexpected EOF");
        }
        return i;
    }

    protected static int read32(InputStream is) throws IOException {
        int i = PiyoPiyoFile.read8(is);
        i |= PiyoPiyoFile.read8(is) << 8;
        i |= PiyoPiyoFile.read8(is) << 16;
        return i |= PiyoPiyoFile.read8(is) << 24;
    }

    protected static void readArray(InputStream is, int[] b) throws IOException {
        for (int i = 0; i < b.length; ++i) {
            b[i] = PiyoPiyoFile.read8(is);
        }
    }

    protected static void write32(OutputStream is, int i) throws IOException {
        is.write(i & 0xFF);
        is.write(i >> 8 & 0xFF);
        is.write(i >> 16 & 0xFF);
        is.write(i >> 24 & 0xFF);
    }

    protected static void writeArray(OutputStream is, int[] b) throws IOException {
        for (int i = 0; i < b.length; ++i) {
            is.write(b[i]);
        }
    }

    public synchronized void trimEnd() {
        int origLen;
        int bestLength;
        for (bestLength = origLen = this.musicFrames.length / 4; bestLength > 1 && this.loopStart != bestLength && this.loopEnd != bestLength; --bestLength) {
            boolean empty = true;
            int lastFrameBase = bestLength - 1;
            for (int i = 0; i < 4; ++i) {
                if (this.musicFrames[lastFrameBase + origLen * i].isEmpty()) continue;
                empty = false;
            }
            if (!empty) break;
        }
        this.resize(bestLength);
    }

    public PiyoPiyoFrame[] getAllFrames() {
        return this.musicFrames;
    }

    public synchronized void setAllFrames(PiyoPiyoFrame[] frames) {
        this.musicFrames = frames;
    }

    public synchronized PiyoPiyoFrame ensureFrame(int i, int track) {
        int fc = this.getFrameCount();
        if (i < 0) {
            return new PiyoPiyoFrame();
        }
        if (i >= fc) {
            this.resize(i + 1);
        }
        return this.getFrameOrNull(i, track);
    }
}

