/*
 * Decompiled with CFR 0.152.
 */
package libpiyo;

public interface ISample {
    public float get(double var1);

    public static class Lerped
    implements ISample {
        public ISample base;

        public Lerped(ISample b) {
            this.base = b;
        }

        @Override
        public float get(double at) {
            double af = Math.floor(at);
            double ofs = at - af;
            float a = this.base.get(af);
            float b = this.base.get(af + 1.0);
            float diff = b - a;
            diff = (float)((double)diff * ofs);
            return a + diff;
        }
    }

    public static class Looped
    implements ISample {
        public ISample base;
        public double loopStart;
        public double loopLength;

        public Looped(ISample b, double loopS, double loopL) {
            this.base = b;
            this.loopStart = loopS;
            this.loopLength = loopL;
        }

        @Override
        public float get(double at) {
            at -= this.loopStart;
            at -= Math.floor(at / this.loopLength) * this.loopLength;
            return this.base.get(at += this.loopStart);
        }
    }

    public static class ArrayF32
    implements ISample {
        public float[] base;

        public ArrayF32(float[] data) {
            this.base = data;
        }

        @Override
        public float get(double at) {
            int index = (int)at;
            if (index < 0) {
                return 0.0f;
            }
            if (index >= this.base.length) {
                return 0.0f;
            }
            return this.base[index];
        }
    }
}

