/*
 * Decompiled with CFR 0.152.
 */
package gabien.vopeks;

import gabien.natives.BadGPUEnum;
import gabien.natives.BadGPUUnsafe;
import gabien.render.IGrDriver;
import gabien.render.IImage;
import gabien.render.IImgRegion;
import gabien.render.ITexRegion;
import gabien.vopeks.Vopeks;
import gabien.vopeks.VopeksBatch;
import gabien.vopeks.VopeksImage;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class VopeksUnbatchingSurface
extends IGrDriver {
    public final Vopeks vopeks;
    private volatile boolean wasDisposed;
    private int upcomingCropL;
    private int upcomingCropU;
    private int upcomingCropR;
    private int upcomingCropD;
    private final float halfWF;
    private final float halfHF;

    public VopeksUnbatchingSurface(@NonNull Vopeks vopeks, @Nullable String id, int w, int h, int[] init) {
        super(id, w, h);
        this.vopeks = vopeks;
        vopeks.putTask(instance -> {
            this.texture = instance.newTexture(w, h, BadGPUEnum.TextureLoadFormat.ARGBI32_SA, init, 0);
        });
        this.halfWF = (float)w / 2.0f;
        this.halfHF = (float)h / 2.0f;
    }

    @Override
    public void getPixelsAsync(int x, int y, int w, int h, BadGPUEnum.TextureLoadFormat format, @NonNull int[] data, int dataOfs, @NonNull Runnable onDone) {
        VopeksImage.getPixelsAsync(this.vopeks, (IImage)this, x, y, w, h, format, data, dataOfs, onDone);
    }

    @Override
    public void getPixelsAsync(int x, int y, int w, int h, BadGPUEnum.TextureLoadFormat format, @NonNull byte[] data, int dataOfs, @NonNull Runnable onDone) {
        VopeksImage.getPixelsAsync(this.vopeks, (IImage)this, x, y, w, h, format, data, dataOfs, onDone);
    }

    @Override
    public synchronized void clearAll(int r, int g, int b, int a) {
        this.batchFlush();
        int scL = this.scissor[0];
        int scU = this.scissor[1];
        int scR = this.scissor[2];
        int scD = this.scissor[3];
        int cropW = scR - scL;
        int cropH = scD - scU;
        this.batchReferenceBarrier();
        this.vopeks.putTask(instance -> BadGPUUnsafe.drawClear(this.texture.pointer, 0L, 12032, scL, scU, cropW, cropH, (float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, (float)a / 255.0f, 0.0f, 0));
    }

    @Override
    public synchronized void generateMipmap() {
        this.batchFlush();
        this.batchReferenceBarrier();
        this.vopeks.putTask(instance -> BadGPUUnsafe.generateMipmap(this.texture.pointer));
    }

    @Override
    public synchronized void shutdown() {
        if (!this.wasDisposed) {
            this.wasDisposed = true;
            this.batchReferenceBarrier();
            this.batchFlush();
            this.vopeks.putTask(instance -> {
                if (this.texture != null) {
                    this.texture.dispose();
                    this.texture = null;
                }
            });
        }
    }

    protected void finalize() {
        this.shutdown();
    }

    private final boolean setupAndCheckCrop(boolean cropEssential, int cropL, int cropU, int cropR, int cropD) {
        int n = cropL < 0 ? 0 : (cropL = cropL > this.width ? this.width : cropL);
        int n2 = cropR < 0 ? 0 : (cropR = cropR > this.width ? this.width : cropR);
        int n3 = cropU < 0 ? 0 : (cropU = cropU > this.height ? this.height : cropU);
        int n4 = cropD < 0 ? 0 : (cropD = cropD > this.height ? this.height : cropD);
        if (cropEssential && (cropR <= cropL || cropD <= cropU)) {
            return true;
        }
        this.upcomingCropL = cropL;
        this.upcomingCropU = cropU;
        this.upcomingCropR = cropR;
        this.upcomingCropD = cropD;
        return false;
    }

    @Override
    public final synchronized void rawBatchXYST(boolean cropEssential, int cropL, int cropU, int cropR, int cropD, int blendMode, int drawFlagsEx, @Nullable ITexRegion iU, float x0, float y0, float s0, float t0, float x1, float y1, float s1, float t1, float x2, float y2, float s2, float t2) {
        if (this.setupAndCheckCrop(cropEssential, cropL, cropU, cropR, cropD)) {
            return;
        }
        this.batchSend(false, cropEssential, blendMode, drawFlagsEx, iU, new float[]{x0, y0, x1, y1, x2, y2, s0, t0, s1, t1, s2, t2});
    }

    @Override
    public final synchronized void rawBatchXYST(boolean cropEssential, int cropL, int cropU, int cropR, int cropD, int blendMode, int drawFlagsEx, @Nullable ITexRegion iU, float x0, float y0, float s0, float t0, float x1, float y1, float s1, float t1, float x2, float y2, float s2, float t2, float x3, float y3, float s3, float t3) {
        if (this.setupAndCheckCrop(cropEssential, cropL, cropU, cropR, cropD)) {
            return;
        }
        this.batchSend(false, cropEssential, blendMode, drawFlagsEx, iU, new float[]{x0, y0, x1, y1, x2, y2, x0, y0, x2, y2, x3, y3, s0, t0, s1, t1, s2, t2, s0, t0, s2, t2, s3, t3});
    }

    @Override
    public final synchronized void rawBatchXYSTRGBA(boolean cropEssential, int cropL, int cropU, int cropR, int cropD, int blendMode, int drawFlagsEx, @Nullable ITexRegion iU, float x0, float y0, float s0, float t0, float r0, float g0, float b0, float a0, float x1, float y1, float s1, float t1, float r1, float g1, float b1, float a1, float x2, float y2, float s2, float t2, float r2, float g2, float b2, float a2) {
        if (this.setupAndCheckCrop(cropEssential, cropL, cropU, cropR, cropD)) {
            return;
        }
        this.batchSend(true, cropEssential, blendMode, drawFlagsEx, iU, new float[]{x0, y0, x1, y1, x2, y2, s0, t0, s1, t1, s2, t2, r0, g0, b0, a0, r1, g1, b1, a1, r2, g2, b2, a2});
    }

    @Override
    public final synchronized void rawBatchXYSTRGBA(boolean cropEssential, int cropL, int cropU, int cropR, int cropD, int blendMode, int drawFlagsEx, @Nullable ITexRegion iU, float x0, float y0, float s0, float t0, float r0, float g0, float b0, float a0, float x1, float y1, float s1, float t1, float r1, float g1, float b1, float a1, float x2, float y2, float s2, float t2, float r2, float g2, float b2, float a2, float x3, float y3, float s3, float t3, float r3, float g3, float b3, float a3) {
        if (this.setupAndCheckCrop(cropEssential, cropL, cropU, cropR, cropD)) {
            return;
        }
        this.batchSend(true, cropEssential, blendMode, drawFlagsEx, iU, new float[]{x0, y0, x1, y1, x2, y2, x0, y0, x2, y2, x3, y3, s0, t0, s1, t1, s2, t2, s0, t0, s2, t2, s3, t3, r0, g0, b0, a0, r1, g1, b1, a1, r2, g2, b2, a2, r0, g0, b0, a0, r2, g2, b2, a2, r3, g3, b3, a3});
    }

    private void batchSend(boolean hasColours, boolean cropEssential, int blendMode, int drawFlagsEx, ITexRegion iU, float[] data) {
        int i;
        this.batchReferenceBarrier();
        int vertexCount = hasColours ? data.length / 8 : data.length / 4;
        IImgRegion tex = null;
        IImage srf = null;
        if (iU != null) {
            tex = iU.pickImgRegion(null);
        }
        if (tex != null) {
            srf = tex.getSurface();
        }
        VopeksBatch currentBatch = new VopeksBatch(this.vopeks, this, null);
        currentBatch.hasColours = hasColours;
        currentBatch.vertexCount = vertexCount;
        if (cropEssential) {
            currentBatch.cropL = this.upcomingCropL;
            currentBatch.cropU = this.upcomingCropU;
            currentBatch.cropR = this.upcomingCropR;
            currentBatch.cropD = this.upcomingCropD;
        } else {
            currentBatch.cropL = 0;
            currentBatch.cropU = 0;
            currentBatch.cropR = this.width;
            currentBatch.cropD = this.height;
        }
        currentBatch.blendMode = blendMode;
        currentBatch.drawFlagsEx = drawFlagsEx;
        currentBatch.tex = srf;
        currentBatch.megabuffer = data;
        currentBatch.verticesOfs = 0;
        currentBatch.texCoordsOfs = vertexCount * 2;
        currentBatch.coloursOfs = vertexCount * 4;
        for (i = 0; i < vertexCount; ++i) {
            int posB = i * 2;
            data[posB] = (data[posB] - this.halfWF) / this.halfWF;
            data[posB + 1] = (data[posB + 1] - this.halfHF) / this.halfHF;
        }
        if (tex != null) {
            for (i = 0; i < vertexCount; ++i) {
                int posT = currentBatch.texCoordsOfs + i * 2;
                float s = data[posT];
                float t = data[posT + 1];
                data[posT] = tex.getS(s, t);
                data[posT + 1] = tex.getT(s, t);
            }
        }
        if (srf != null) {
            srf.batchReference(this);
        }
        this.vopeks.putTask(currentBatch);
        if (srf != null) {
            srf.batchUnreference(this);
        }
    }

    @Override
    public synchronized void batchFlush() {
    }
}

