/*
 * Decompiled with CFR 0.152.
 */
package gabien.vopeks;

import gabien.natives.BadGPU;
import gabien.natives.BadGPUEnum;
import gabien.render.IImage;
import gabien.uslx.append.TimeLogger;
import gabien.vopeks.Vopeks;
import java.util.function.Consumer;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class VopeksImage
extends IImage {
    public final Vopeks vopeks;
    private volatile boolean wasDisposed;

    public VopeksImage(@NonNull Vopeks vopeks, @Nullable String id, int w, int h, BadGPUEnum.TextureLoadFormat tlf, int[] init) {
        super(id, w, h);
        this.vopeks = vopeks;
        vopeks.putTask(instance -> {
            this.texture = instance.newTexture(w, h, tlf, init, 0);
        });
    }

    public VopeksImage(@NonNull Vopeks vopeks, @Nullable String id, int w, int h, BadGPUEnum.TextureLoadFormat tlf, byte[] init) {
        super(id, w, h);
        this.vopeks = vopeks;
        vopeks.putTask(instance -> {
            this.texture = instance.newTexture(w, h, tlf, init, 0);
        });
    }

    public VopeksImage(Vopeks vopeks, @Nullable String id, int w, int h, Consumer<Consumer<BadGPU.Texture>> grabber) {
        super(id, w, h);
        this.vopeks = vopeks;
        grabber.accept(res -> {
            this.texture = res;
        });
    }

    @Override
    public void batchFlush() {
    }

    @Override
    public void batchReference(IImage other) {
    }

    @Override
    public void batchUnreference(IImage caller) {
    }

    public static void getPixelsAsync(Vopeks vopeks, IImage image, int x, int y, int w, int h, BadGPUEnum.TextureLoadFormat format, @NonNull int[] data, int dataOfs, @NonNull Runnable onDone) {
        vopeks.putTask(instance -> {
            try (TimeLogger.Source src = TimeLogger.open(vopeks.timeLoggerReadPixelsTask);){
                BadGPU.Texture texture = image.getTextureFromTask();
                if (texture != null) {
                    texture.readPixels(x, y, w, h, format, data, dataOfs);
                }
            }
            vopeks.putCallback(onDone);
        });
    }

    public static void getPixelsAsync(Vopeks vopeks, IImage image, int x, int y, int w, int h, BadGPUEnum.TextureLoadFormat format, @NonNull byte[] data, int dataOfs, @NonNull Runnable onDone) {
        vopeks.putTask(instance -> {
            try (TimeLogger.Source src = TimeLogger.open(vopeks.timeLoggerReadPixelsTask);){
                BadGPU.Texture texture = image.getTextureFromTask();
                if (texture != null) {
                    texture.readPixels(x, y, w, h, format, data, dataOfs);
                }
            }
            vopeks.putCallback(onDone);
        });
    }

    @Override
    public void getPixelsAsync(int x, int y, int w, int h, BadGPUEnum.TextureLoadFormat format, @NonNull int[] data, int dataOfs, @NonNull Runnable onDone) {
        VopeksImage.getPixelsAsync(this.vopeks, (IImage)this, x, y, w, h, format, data, dataOfs, onDone);
    }

    @Override
    public void getPixelsAsync(int x, int y, int w, int h, BadGPUEnum.TextureLoadFormat format, @NonNull byte[] data, int dataOfs, @NonNull Runnable onDone) {
        VopeksImage.getPixelsAsync(this.vopeks, (IImage)this, x, y, w, h, format, data, dataOfs, onDone);
    }

    protected void finalize() {
        this.shutdown();
    }

    public synchronized void shutdown() {
        if (!this.wasDisposed) {
            this.wasDisposed = true;
            this.vopeks.putTask(instance -> {
                if (this.texture != null) {
                    this.texture.dispose();
                }
            });
        }
    }
}

