/*
 * Decompiled with CFR 0.152.
 */
package gabien.vopeks;

import gabien.uslx.append.ObjectPool;
import org.eclipse.jdt.annotation.NonNull;

public final class VopeksFloatPool {
    private final Sized pool64 = new Sized(64, 1);
    private final Sized pool1024 = new Sized(1024, 1);
    private final Sized pool16384 = new Sized(16384, 1);
    private final Sized pool65536 = new Sized(65536, 1);
    private final Sized pool786432 = new Sized(786432, 1);

    public float[] get(int len) {
        if (len <= 64) {
            return (float[])this.pool64.get();
        }
        if (len <= 1024) {
            return (float[])this.pool1024.get();
        }
        if (len <= 16384) {
            return (float[])this.pool16384.get();
        }
        if (len <= 65536) {
            return (float[])this.pool65536.get();
        }
        if (len <= 786432) {
            return (float[])this.pool786432.get();
        }
        return new float[len];
    }

    public void finish(float[] megabuffer) {
        if (megabuffer.length == 64) {
            this.pool64.finish(megabuffer);
        } else if (megabuffer.length == 1024) {
            this.pool1024.finish(megabuffer);
        } else if (megabuffer.length == 16384) {
            this.pool16384.finish(megabuffer);
        } else if (megabuffer.length == 65536) {
            this.pool65536.finish(megabuffer);
        } else if (megabuffer.length == 786432) {
            this.pool786432.finish(megabuffer);
        }
    }

    private static class Sized
    extends ObjectPool<float[]> {
        public final int length;

        Sized(int l, int e) {
            super(e);
            this.length = l;
        }

        @Override
        @NonNull
        protected float[] gen() {
            return new float[this.length];
        }

        @Override
        public void reset(@NonNull float[] element) {
        }
    }
}

