/*
 * Decompiled with CFR 0.152.
 */
package gabien.vopeks;

import gabien.natives.BadGPUEnum;
import gabien.natives.BadGPUUnsafe;
import gabien.render.IGrDriver;
import gabien.render.IImage;
import gabien.render.IImgRegion;
import gabien.render.ITexRegion;
import gabien.vopeks.Vopeks;
import gabien.vopeks.VopeksBatch;
import gabien.vopeks.VopeksBatchPool;
import gabien.vopeks.VopeksImage;
import java.util.Arrays;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class VopeksBatchingSurface
extends IGrDriver {
    public final Vopeks vopeks;
    private volatile boolean wasDisposed;
    private final VopeksBatchPool batchPool;
    private VopeksBatch currentBatch = null;
    private final int maxVerticesInBatch;
    private final float[] stagingV;
    private final float[] stagingC;
    private final float[] stagingT;
    private final float halfWF;
    private final float halfHF;
    private int upcomingCropL;
    private int upcomingCropU;
    private int upcomingCropR;
    private int upcomingCropD;

    public VopeksBatchingSurface(@NonNull Vopeks vopeks, @Nullable String id, int w, int h, int[] init, int maxVerticesInBatch) {
        super(id, w, h);
        this.vopeks = vopeks;
        this.batchPool = new VopeksBatchPool(vopeks, this, 1);
        if (maxVerticesInBatch < 6) {
            throw new RuntimeException("To function properly, there must be at least 6 vertices supported per batch.");
        }
        this.maxVerticesInBatch = maxVerticesInBatch;
        this.stagingV = new float[maxVerticesInBatch * 4];
        this.stagingC = new float[maxVerticesInBatch * 4];
        this.stagingT = new float[maxVerticesInBatch * 4];
        vopeks.putTask(instance -> {
            this.texture = instance.newTexture(w, h, BadGPUEnum.TextureLoadFormat.ARGBI32_SA, init, 0);
        });
        this.halfWF = (float)w / 2.0f;
        this.halfHF = (float)h / 2.0f;
    }

    @Override
    public void getPixelsAsync(int x, int y, int w, int h, BadGPUEnum.TextureLoadFormat format, @NonNull int[] data, int dataOfs, @NonNull Runnable onDone) {
        VopeksImage.getPixelsAsync(this.vopeks, (IImage)this, x, y, w, h, format, data, dataOfs, onDone);
    }

    @Override
    public void getPixelsAsync(int x, int y, int w, int h, BadGPUEnum.TextureLoadFormat format, @NonNull byte[] data, int dataOfs, @NonNull Runnable onDone) {
        VopeksImage.getPixelsAsync(this.vopeks, (IImage)this, x, y, w, h, format, data, dataOfs, onDone);
    }

    @Override
    public synchronized void clearAll(int r, int g, int b, int a) {
        this.batchFlush();
        int scL = this.scissor[0];
        int scU = this.scissor[1];
        int scR = this.scissor[2];
        int scD = this.scissor[3];
        int cropW = scR - scL;
        int cropH = scD - scU;
        this.batchReferenceBarrier();
        this.vopeks.putTask(instance -> BadGPUUnsafe.drawClear(this.texture.pointer, 0L, 12032, scL, scU, cropW, cropH, (float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, (float)a / 255.0f, 0.0f, 0));
    }

    @Override
    public synchronized void generateMipmap() {
        this.batchFlush();
        this.batchReferenceBarrier();
        this.vopeks.putTask(instance -> BadGPUUnsafe.generateMipmap(this.texture.pointer));
    }

    @Override
    public synchronized void shutdown() {
        if (!this.wasDisposed) {
            this.wasDisposed = true;
            this.batchReferenceBarrier();
            this.batchFlush();
            this.vopeks.putTask(instance -> {
                if (this.texture != null) {
                    this.texture.dispose();
                    this.texture = null;
                }
            });
        }
    }

    protected void finalize() {
        this.shutdown();
    }

    private final boolean setupAndCheckCrop(boolean cropEssential, int cropL, int cropU, int cropR, int cropD) {
        int n = cropL < 0 ? 0 : (cropL = cropL > this.width ? this.width : cropL);
        int n2 = cropR < 0 ? 0 : (cropR = cropR > this.width ? this.width : cropR);
        int n3 = cropU < 0 ? 0 : (cropU = cropU > this.height ? this.height : cropU);
        int n4 = cropD < 0 ? 0 : (cropD = cropD > this.height ? this.height : cropD);
        if (cropEssential && (cropR <= cropL || cropD <= cropU)) {
            return true;
        }
        this.upcomingCropL = cropL;
        this.upcomingCropU = cropU;
        this.upcomingCropR = cropR;
        this.upcomingCropD = cropD;
        return false;
    }

    @Override
    public final synchronized void rawBatchXYST(boolean cropEssential, int cropL, int cropU, int cropR, int cropD, int blendMode, int drawFlagsEx, @Nullable ITexRegion iU, float x0, float y0, float s0, float t0, float x1, float y1, float s1, float t1, float x2, float y2, float s2, float t2) {
        if (this.setupAndCheckCrop(cropEssential, cropL, cropU, cropR, cropD)) {
            return;
        }
        IImgRegion tex = this.batchStartGroup(3, false, cropEssential, blendMode, drawFlagsEx, iU);
        this.batchWriteXYSTRGBA(x0, y0, s0, t0, 1.0f, 1.0f, 1.0f, 1.0f, tex);
        this.batchWriteXYSTRGBA(x1, y1, s1, t1, 1.0f, 1.0f, 1.0f, 1.0f, tex);
        this.batchWriteXYSTRGBA(x2, y2, s2, t2, 1.0f, 1.0f, 1.0f, 1.0f, tex);
    }

    @Override
    public final synchronized void rawBatchXYST(boolean cropEssential, int cropL, int cropU, int cropR, int cropD, int blendMode, int drawFlagsEx, @Nullable ITexRegion iU, float x0, float y0, float s0, float t0, float x1, float y1, float s1, float t1, float x2, float y2, float s2, float t2, float x3, float y3, float s3, float t3) {
        if (this.setupAndCheckCrop(cropEssential, cropL, cropU, cropR, cropD)) {
            return;
        }
        IImgRegion tex = this.batchStartGroup(6, false, cropEssential, blendMode, drawFlagsEx, iU);
        this.batchWriteXYSTRGBA(x0, y0, s0, t0, 1.0f, 1.0f, 1.0f, 1.0f, tex);
        this.batchWriteXYSTRGBA(x1, y1, s1, t1, 1.0f, 1.0f, 1.0f, 1.0f, tex);
        this.batchWriteXYSTRGBA(x2, y2, s2, t2, 1.0f, 1.0f, 1.0f, 1.0f, tex);
        this.batchWriteXYSTRGBA(x0, y0, s0, t0, 1.0f, 1.0f, 1.0f, 1.0f, tex);
        this.batchWriteXYSTRGBA(x2, y2, s2, t2, 1.0f, 1.0f, 1.0f, 1.0f, tex);
        this.batchWriteXYSTRGBA(x3, y3, s3, t3, 1.0f, 1.0f, 1.0f, 1.0f, tex);
    }

    @Override
    public final synchronized void rawBatchXYSTRGBA(boolean cropEssential, int cropL, int cropU, int cropR, int cropD, int blendMode, int drawFlagsEx, @Nullable ITexRegion iU, float x0, float y0, float s0, float t0, float r0, float g0, float b0, float a0, float x1, float y1, float s1, float t1, float r1, float g1, float b1, float a1, float x2, float y2, float s2, float t2, float r2, float g2, float b2, float a2) {
        if (this.setupAndCheckCrop(cropEssential, cropL, cropU, cropR, cropD)) {
            return;
        }
        IImgRegion tex = this.batchStartGroup(3, true, cropEssential, blendMode, drawFlagsEx, iU);
        this.batchWriteXYSTRGBA(x0, y0, s0, t0, r0, g0, b0, a0, tex);
        this.batchWriteXYSTRGBA(x1, y1, s1, t1, r1, g1, b1, a1, tex);
        this.batchWriteXYSTRGBA(x2, y2, s2, t2, r2, g2, b2, a2, tex);
    }

    @Override
    public final synchronized void rawBatchXYSTRGBA(boolean cropEssential, int cropL, int cropU, int cropR, int cropD, int blendMode, int drawFlagsEx, @Nullable ITexRegion iU, float x0, float y0, float s0, float t0, float r0, float g0, float b0, float a0, float x1, float y1, float s1, float t1, float r1, float g1, float b1, float a1, float x2, float y2, float s2, float t2, float r2, float g2, float b2, float a2, float x3, float y3, float s3, float t3, float r3, float g3, float b3, float a3) {
        if (this.setupAndCheckCrop(cropEssential, cropL, cropU, cropR, cropD)) {
            return;
        }
        IImgRegion tex = this.batchStartGroup(6, true, cropEssential, blendMode, drawFlagsEx, iU);
        this.batchWriteXYSTRGBA(x0, y0, s0, t0, r0, g0, b0, a0, tex);
        this.batchWriteXYSTRGBA(x1, y1, s1, t1, r1, g1, b1, a1, tex);
        this.batchWriteXYSTRGBA(x2, y2, s2, t2, r2, g2, b2, a2, tex);
        this.batchWriteXYSTRGBA(x0, y0, s0, t0, r0, g0, b0, a0, tex);
        this.batchWriteXYSTRGBA(x2, y2, s2, t2, r2, g2, b2, a2, tex);
        this.batchWriteXYSTRGBA(x3, y3, s3, t3, r3, g3, b3, a3, tex);
    }

    @Nullable
    private IImgRegion batchStartGroup(int vertices, boolean hasColours, boolean cropEssential, int blendMode, int drawFlagsEx, ITexRegion iU) {
        this.batchReferenceBarrier();
        if (this.currentBatch != null && this.currentBatch.vertexCount + vertices > this.maxVerticesInBatch) {
            this.batchFlush();
        }
        IImgRegion tex = null;
        IImage srf = null;
        if (iU != null) {
            tex = iU.pickImgRegion(this.currentBatch != null ? this.currentBatch.tex : null);
        }
        if (tex != null) {
            srf = tex.getSurface();
        }
        if (this.currentBatch == null || !this.currentBatch.matchesState(cropEssential, this.upcomingCropL, this.upcomingCropU, this.upcomingCropR, this.upcomingCropD, blendMode, drawFlagsEx, srf)) {
            this.batchFlush();
            if (srf != null) {
                srf.batchReference(this);
            }
            this.currentBatch = (VopeksBatch)this.batchPool.get();
            this.currentBatch.hasColours = hasColours;
            this.currentBatch.cropEssential = cropEssential;
            if (cropEssential) {
                this.currentBatch.cropL = this.upcomingCropL;
                this.currentBatch.cropU = this.upcomingCropU;
                this.currentBatch.cropR = this.upcomingCropR;
                this.currentBatch.cropD = this.upcomingCropD;
            } else {
                this.currentBatch.cropL = 0;
                this.currentBatch.cropU = 0;
                this.currentBatch.cropR = this.width;
                this.currentBatch.cropD = this.height;
            }
            this.currentBatch.blendMode = blendMode;
            this.currentBatch.drawFlagsEx = drawFlagsEx;
            this.currentBatch.tex = srf;
        }
        if (hasColours && !this.currentBatch.hasColours) {
            Arrays.fill(this.stagingC, 0, this.currentBatch.vertexCount * 4, 1.0f);
            this.currentBatch.hasColours = true;
        }
        return tex;
    }

    @Override
    public synchronized void batchFlush() {
        if (this.currentBatch != null) {
            int groupVLen = this.currentBatch.vertexCount * 2;
            int groupCLen = this.currentBatch.vertexCount * 4;
            int groupTLen = this.currentBatch.tex != null ? this.currentBatch.vertexCount * 2 : 0;
            int groupTotalLen = groupVLen + groupCLen + groupTLen;
            float[] megabuffer = this.vopeks.floatPool.get(groupTotalLen);
            int groupVOfs = 0;
            int groupCOfs = groupVOfs + groupVLen;
            int groupTOfs = groupCOfs + groupCLen;
            this.currentBatch.megabuffer = megabuffer;
            this.currentBatch.verticesOfs = groupVOfs;
            this.currentBatch.coloursOfs = groupCOfs;
            this.currentBatch.texCoordsOfs = groupTOfs;
            System.arraycopy(this.stagingV, 0, megabuffer, groupVOfs, groupVLen);
            System.arraycopy(this.stagingC, 0, megabuffer, groupCOfs, groupCLen);
            if (this.currentBatch.tex != null) {
                System.arraycopy(this.stagingT, 0, megabuffer, groupTOfs, groupTLen);
                this.currentBatch.tex.batchUnreference(this);
            }
            this.vopeks.putTask(this.currentBatch);
        }
        this.currentBatch = null;
    }

    private void batchWriteXYSTRGBA(float x, float y, float s, float t, float r, float g, float b, float a, @Nullable IImgRegion tf) {
        int vertexBase2 = this.currentBatch.vertexCount * 2;
        int vertexBase4 = this.currentBatch.vertexCount * 4;
        this.stagingV[vertexBase2] = (x - this.halfWF) / this.halfWF;
        this.stagingV[vertexBase2 + 1] = (y - this.halfHF) / this.halfHF;
        if (tf != null) {
            float nS = tf.getS(s, t);
            float nT = tf.getT(s, t);
            this.stagingT[vertexBase2] = nS;
            this.stagingT[vertexBase2 + 1] = nT;
        }
        if (this.currentBatch.hasColours) {
            this.stagingC[vertexBase4] = r;
            this.stagingC[vertexBase4 + 1] = g;
            this.stagingC[vertexBase4 + 2] = b;
            this.stagingC[vertexBase4 + 3] = a;
        }
        ++this.currentBatch.vertexCount;
    }
}

