/*
 * Decompiled with CFR 0.152.
 */
package gabien.vopeks;

import gabien.natives.BadGPU;
import gabien.natives.BadGPUEnum;
import gabien.natives.BadGPUUnsafe;
import gabien.render.IGrDriver;
import gabien.render.IImage;
import gabien.uslx.append.ObjectPool;
import gabien.vopeks.Vopeks;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

class VopeksBatch
implements Vopeks.ITask {
    private final Vopeks vopeks;
    private final IImage parent;
    private final ObjectPool<VopeksBatch> srcPool;
    int cropL;
    int cropU;
    int cropR;
    int cropD;
    int vertexCount;
    int blendMode = IGrDriver.BLEND_NONE;
    int drawFlagsEx = 0;
    IImage tex;
    float[] megabuffer;
    int verticesOfs;
    int coloursOfs;
    int texCoordsOfs;
    boolean hasColours;
    boolean cropEssential;

    VopeksBatch(@NonNull Vopeks vopeks, @NonNull IImage parent, @Nullable ObjectPool<VopeksBatch> pool) {
        this.vopeks = vopeks;
        this.parent = parent;
        this.srcPool = pool;
    }

    @Override
    public void run(BadGPU.Instance instance) {
        BadGPU.Texture screen = this.parent.getTextureFromTask();
        if (screen == null) {
            System.err.println("VopeksBatchingSurface: Texture disappeared from " + this.parent + ". Someone try something silly?");
            return;
        }
        BadGPU.Texture tx = this.tex != null ? this.tex.getTextureFromTask() : null;
        long tx2 = tx != null ? tx.pointer : 0L;
        int alphaComp = BadGPUEnum.Compare.Always.value;
        int drawFlags = 0;
        if (this.blendMode != IGrDriver.BLEND_NONE) {
            drawFlags |= 0x20;
        }
        if (this.blendMode == IGrDriver.BLEND_NORMAL) {
            alphaComp = BadGPUEnum.Compare.Greater.value;
        }
        BadGPUUnsafe.drawGeomNoDS(screen.pointer, 12032, this.cropL, this.cropU, this.cropR - this.cropL, this.cropD - this.cropU, drawFlags |= this.drawFlagsEx, 2, this.megabuffer, this.verticesOfs, this.hasColours ? this.megabuffer : null, this.coloursOfs, 2, tx == null ? null : this.megabuffer, this.texCoordsOfs, BadGPUEnum.PrimitiveType.Triangles.value, 1.0f, 0, this.vertexCount, null, 0, null, 0, 0, 0, this.parent.width, this.parent.height, tx2, null, 0, null, 0, alphaComp, 0.0f, this.blendMode);
        this.vopeks.floatPool.finish(this.megabuffer);
        if (this.srcPool != null) {
            this.srcPool.finish(this);
        }
    }

    public boolean matchesState(boolean cropEssential, int cropL, int cropU, int cropR, int cropD, int blendMode, int drawFlagsEx, IImage tex) {
        if (cropEssential ? cropL != this.cropL || cropU != this.cropU || cropR != this.cropR || cropD != this.cropD : this.cropEssential && (cropL > this.cropL || cropU > this.cropU || cropR < this.cropR || cropD < this.cropD)) {
            return false;
        }
        if (tex != this.tex) {
            return false;
        }
        if (blendMode != this.blendMode) {
            return false;
        }
        return drawFlagsEx == this.drawFlagsEx;
    }
}

