/*
 * Decompiled with CFR 0.152.
 */
package gabien.vopeks;

import gabien.natives.BadGPU;
import gabien.uslx.append.EmptyLambdas;
import gabien.uslx.append.TimeLogger;
import gabien.vopeks.VopeksFloatPool;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jdt.annotation.Nullable;

public final class Vopeks {
    private final int TASK_QUEUE_SIZE = 65536;
    private int tasksBetweenFlushes = 0;
    @Nullable
    public final TimeLogger timeLogger;
    @Nullable
    public final TimeLogger.Source timeLoggerReadPixelsTask;
    @Nullable
    public final TimeLogger.Source timeLoggerFlushTask;
    @Nullable
    public final TimeLogger.Source timeLoggerFinishTask;
    public final Thread vopeksThread;
    public final CallbackRunner vopeksCBThread;
    private final ArrayBlockingQueue<ITask> taskQueue = new ArrayBlockingQueue(65536);
    private final ArrayBlockingQueue<Runnable> cbQueue = new ArrayBlockingQueue(65536);
    public final VopeksFloatPool floatPool = new VopeksFloatPool();
    private volatile boolean shutdownPrimary;
    public final AtomicReference<Throwable> initFailure = new AtomicReference();
    public final AtomicBoolean initComplete = new AtomicBoolean();

    public Vopeks(final int newInstanceFlags, final @Nullable TimeLogger timeLogger, final boolean isCrashingVopeks) {
        this.timeLogger = timeLogger;
        this.timeLoggerReadPixelsTask = TimeLogger.optSource(timeLogger, "readPixelsTask");
        this.timeLoggerFlushTask = TimeLogger.optSource(timeLogger, "flushTask");
        this.timeLoggerFinishTask = TimeLogger.optSource(timeLogger, "finishTask");
        this.vopeksThread = new Thread("VOPEKS Thread"){

            @Override
            public void run() {
                BadGPU.Instance instance;
                try {
                    instance = BadGPU.newInstance(newInstanceFlags);
                    if (isCrashingVopeks) {
                        throw new RuntimeException("Told to crash VOPEKS");
                    }
                }
                catch (Throwable t) {
                    Vopeks.this.initFailure.set(t);
                    throw t;
                }
                finally {
                    Vopeks.this.initComplete.set(true);
                }
                if (timeLogger != null) {
                    TimeLogger.Source vs = timeLogger.newSource("vopeks_main");
                    while (!Vopeks.this.shutdownPrimary) {
                        try {
                            ITask task = (ITask)Vopeks.this.taskQueue.take();
                            Vopeks.this.tasksBetweenFlushes++;
                            TimeLogger.Source vs2 = TimeLogger.open(vs);
                            Throwable throwable = null;
                            try {
                                task.run(instance);
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (vs2 == null) continue;
                                if (throwable != null) {
                                    try {
                                        vs2.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                    continue;
                                }
                                vs2.close();
                            }
                        }
                        catch (Throwable t) {
                            System.err.println("Exception in VOPEKS:");
                            t.printStackTrace();
                        }
                    }
                } else {
                    while (!Vopeks.this.shutdownPrimary) {
                        try {
                            ((ITask)Vopeks.this.taskQueue.take()).run(instance);
                        }
                        catch (Throwable t) {
                            System.err.println("Exception in VOPEKS:");
                            t.printStackTrace();
                        }
                    }
                }
                instance.dispose();
            }
        };
        this.vopeksCBThread = new CallbackRunner("VOPEKS Callback Thread", this.cbQueue);
        this.vopeksThread.start();
        this.vopeksCBThread.start();
    }

    public void putTask(ITask object) {
        if (this.shutdownPrimary) {
            return;
        }
        try {
            this.taskQueue.put(object);
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
    }

    public void putCallback(Runnable object) {
        if (this.vopeksCBThread.shutdown) {
            return;
        }
        try {
            this.cbQueue.put(object);
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
    }

    public void putBatchStatisticsTask() {
        if (this.timeLoggerFlushTask != null) {
            this.putTask(instance -> {
                --this.tasksBetweenFlushes;
                System.out.println("VOPEKS: Tasks between flushes: " + this.tasksBetweenFlushes);
                this.tasksBetweenFlushes = 0;
            });
        }
    }

    public void putFlushTask() {
        if (this.timeLoggerFlushTask != null) {
            this.putTask(instance -> {
                try (TimeLogger.Source src = TimeLogger.open(this.timeLoggerFlushTask);){
                    instance.flush();
                }
            });
        } else {
            this.putTask(instance -> instance.flush());
        }
    }

    public void putFinishTask() {
        if (this.timeLoggerFinishTask != null) {
            this.putTask(instance -> {
                try (TimeLogger.Source src = TimeLogger.open(this.timeLoggerFinishTask);){
                    instance.finish();
                }
            });
        } else {
            this.putTask(instance -> instance.finish());
        }
    }

    public void shutdown() {
        this.shutdownPrimary = true;
        this.vopeksCBThread.shutdown = true;
        try {
            this.taskQueue.put(instance -> {});
            this.vopeksThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            this.cbQueue.put(EmptyLambdas.emptyRunnable);
            this.vopeksCBThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private class CallbackRunner
    extends Thread {
        public volatile boolean shutdown;
        public final ArrayBlockingQueue<Runnable> queue;

        public CallbackRunner(String name, ArrayBlockingQueue<Runnable> queue) {
            super(name);
            this.queue = queue;
        }

        @Override
        public void run() {
            if (Vopeks.this.timeLogger != null) {
                TimeLogger.Source vs = Vopeks.this.timeLogger.newSource(this.getName());
                while (!this.shutdown) {
                    try {
                        Runnable task = this.queue.take();
                        TimeLogger.Source vs2 = TimeLogger.open(vs);
                        Throwable throwable = null;
                        try {
                            task.run();
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (vs2 == null) continue;
                            if (throwable != null) {
                                try {
                                    vs2.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            vs2.close();
                        }
                    }
                    catch (Throwable t) {
                        System.err.println("Exception in " + this.getName() + ":");
                        t.printStackTrace();
                    }
                }
            } else {
                while (!this.shutdown) {
                    try {
                        this.queue.take().run();
                    }
                    catch (Throwable t) {
                        System.err.println("Exception in " + this.getName() + ":");
                        t.printStackTrace();
                    }
                }
            }
        }
    }

    public static interface ITask {
        public void run(BadGPU.Instance var1);
    }
}

