/*
 * Decompiled with CFR 0.152.
 */
package gabien.uslx.vfs.impl;

import gabien.uslx.vfs.FSBackend;
import gabien.uslx.vfs.impl.JavaIOFSBackend;
import gabien.uslx.vfs.impl.WindowsPathModel;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class WindowsRootJavaIOFSBackend
extends FSBackend {
    static final WindowsRootJavaIOFSBackend INSTANCE = new WindowsRootJavaIOFSBackend();

    private WindowsRootJavaIOFSBackend() {
        super(null, WindowsPathModel.INSTANCE, true);
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this;
    }

    @Override
    public int hashCode() {
        return 0;
    }

    @Override
    @NonNull
    public FSBackend intoInner(String dirName) {
        return JavaIOFSBackend.from(new File(dirName + "/"));
    }

    @Override
    public boolean mkdir() {
        return true;
    }

    public static String doRootStrip(String str) {
        if (str.endsWith("\\") || str.endsWith("/")) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    @Override
    @Nullable
    public FSBackend.XState getState() {
        File[] fn = File.listRoots();
        String[] res = new String[fn.length];
        for (int i = 0; i < fn.length; ++i) {
            String str = fn.toString();
            res[i] = str = WindowsRootJavaIOFSBackend.doRootStrip(str);
        }
        FSBackend.DirectoryState ds = new FSBackend.DirectoryState(res);
        return ds;
    }

    @Override
    @NonNull
    public InputStream openRead() throws IOException {
        throw new IOException("is root");
    }

    @Override
    @NonNull
    public OutputStream openWrite() throws IOException {
        throw new IOException("is root");
    }

    @Override
    public void changeTime(long time) {
    }

    @Override
    public boolean delete() {
        return false;
    }

    @Override
    public String getAbsolutePath() {
        return "";
    }
}

