/*
 * Decompiled with CFR 0.152.
 */
package gabien.uslx.vfs.impl;

import gabien.uslx.vfs.PathModel;
import java.io.IOException;
import java.util.LinkedList;

public class WindowsPathModel
extends PathModel {
    public static final WindowsPathModel INSTANCE = new WindowsPathModel();

    private WindowsPathModel() {
    }

    @Override
    public boolean estimatePathComponentEquality(String a, String b) {
        return a.equalsIgnoreCase(b);
    }

    @Override
    public String estimatePathComponentFolding(String a) {
        return a.toLowerCase();
    }

    @Override
    public boolean verifyPathComponent(boolean isFirstAbsComponent, String dirName) {
        if (dirName.isEmpty()) {
            return false;
        }
        if (dirName.contains("/") || dirName.contains("\\")) {
            return false;
        }
        return !(isFirstAbsComponent ? dirName.length() != 2 || dirName.charAt(1) != ':' : dirName.contains(":"));
    }

    @Override
    public String nameOf(String anyPath) {
        anyPath = anyPath.replace('\\', '/');
        String[] opts = anyPath.split("/");
        return opts[opts.length - 1];
    }

    @Override
    public String[] absPathToComponents(String absolutePath) throws IOException {
        absolutePath = absolutePath.replace('\\', '/');
        String[] components = absolutePath.split("/");
        LinkedList<String> finale = new LinkedList<String>();
        boolean first = true;
        for (String component : components) {
            if (component.equals("") && !first) continue;
            if (!this.verifyPathComponent(first, component)) {
                throw new IOException("Invalid path component in " + absolutePath);
            }
            first = false;
            finale.add(component);
        }
        return finale.toArray(new String[finale.size()]);
    }

    @Override
    public String[] relPathToComponents(String absolutePath) throws IOException {
        if ((absolutePath = absolutePath.replace('\\', '/')).startsWith("/")) {
            throw new IOException("Empty component at start not allowed in relative paths");
        }
        String[] components = absolutePath.split("/");
        LinkedList<String> finale = new LinkedList<String>();
        for (String component : components) {
            if (component.equals("")) continue;
            if (!this.verifyPathComponent(false, component)) {
                throw new IOException("Invalid path component in " + absolutePath);
            }
            finale.add(component);
        }
        return finale.toArray(new String[finale.size()]);
    }
}

