/*
 * Decompiled with CFR 0.152.
 */
package gabien.uslx.vfs.impl;

import gabien.uslx.vfs.PathModel;
import java.io.IOException;
import java.util.LinkedList;

public class UnixPathModel
extends PathModel {
    public static final UnixPathModel INSTANCE = new UnixPathModel();

    private UnixPathModel() {
    }

    @Override
    public boolean estimatePathComponentEquality(String a, String b) {
        return a.equals(b);
    }

    @Override
    public String estimatePathComponentFolding(String a) {
        return a;
    }

    @Override
    public boolean verifyPathComponent(boolean isFirstAbsComponent, String dirName) {
        if (dirName.isEmpty()) {
            return false;
        }
        return !dirName.contains("/");
    }

    @Override
    public String nameOf(String anyPath) {
        String[] opts = anyPath.split("/");
        return opts[opts.length - 1];
    }

    @Override
    public String[] relPathToComponents(String absolutePath) throws IOException {
        if (absolutePath.startsWith("/")) {
            throw new IOException("Empty component at start not allowed in relative paths");
        }
        String[] components = absolutePath.split("/");
        LinkedList<String> finale = new LinkedList<String>();
        for (String component : components) {
            if (component.equals("")) continue;
            if (!this.verifyPathComponent(false, component)) {
                throw new IOException("Invalid path component in " + absolutePath);
            }
            finale.add(component);
        }
        return finale.toArray(new String[finale.size()]);
    }

    @Override
    public String[] absPathToComponents(String absolutePath) throws IOException {
        if (!absolutePath.startsWith("/")) {
            throw new IOException("Empty component at start required in absolute paths");
        }
        String[] components = absolutePath.split("/");
        LinkedList<String> finale = new LinkedList<String>();
        for (String component : components) {
            if (component.equals("")) continue;
            if (!this.verifyPathComponent(false, component)) {
                throw new IOException("Invalid path component in " + absolutePath);
            }
            finale.add(component);
        }
        return finale.toArray(new String[finale.size()]);
    }
}

