/*
 * Decompiled with CFR 0.152.
 */
package gabien.uslx.vfs.impl;

import gabien.uslx.vfs.FSBackend;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class UnionFSBackend
extends FSBackend {
    private final FSBackend mutable;
    private final FSBackend[] parents;

    public UnionFSBackend(FSBackend mutable, FSBackend ... parents) {
        this((FSBackend)null, mutable, parents);
    }

    private UnionFSBackend(FSBackend parent, FSBackend mutable, FSBackend ... parents) {
        super(parent, mutable.pathModel, mutable.usesRootPathLogic);
        this.mutable = mutable;
        this.parents = parents;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof UnionFSBackend) {
            UnionFSBackend other = (UnionFSBackend)obj;
            if (!other.mutable.equals(this.mutable)) {
                return false;
            }
            if (other.parents.length != this.parents.length) {
                return false;
            }
            for (int i = 0; i < this.parents.length; ++i) {
                if (this.parents[i].equals(other.parents[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.mutable.hashCode();
    }

    public String toString() {
        return "union:" + this.mutable.toString();
    }

    @Override
    @NonNull
    protected FSBackend intoInner(String dirName) {
        if (dirName.equals("..")) {
            return this.parentOrRoot;
        }
        FSBackend[] newParents = new FSBackend[this.parents.length];
        for (int i = 0; i < newParents.length; ++i) {
            newParents[i] = this.parents[i].into(dirName);
        }
        return new UnionFSBackend((FSBackend)this, this.mutable.into(dirName), newParents);
    }

    @Override
    public String getAbsolutePath() {
        return this.mutable.getAbsolutePath();
    }

    @Override
    public boolean mkdir() {
        return this.mutable.mkdir();
    }

    @Override
    @Nullable
    public FSBackend.XState getState() {
        FSBackend.XState[] allStates = new FSBackend.XState[this.parents.length + 1];
        FSBackend.XState firstState = allStates[0] = this.mutable.getState();
        for (int i = 0; i < this.parents.length; ++i) {
            FSBackend.XState thisState;
            allStates[i + 1] = thisState = this.parents[i].getState();
            if (firstState != null) continue;
            firstState = thisState;
        }
        if (firstState instanceof FSBackend.DirectoryState) {
            ArrayList<String> children = new ArrayList<String>(((FSBackend.DirectoryState)firstState).entries.length);
            HashSet<String> childrenOverlap = new HashSet<String>();
            for (FSBackend.XState chk : allStates) {
                if (!(chk instanceof FSBackend.DirectoryState)) continue;
                for (String s : ((FSBackend.DirectoryState)chk).entries) {
                    if (!childrenOverlap.add(this.pathModel.estimatePathComponentFolding(s))) continue;
                    children.add(s);
                }
            }
            return new FSBackend.DirectoryState(children.toArray(new String[children.size()]));
        }
        return firstState;
    }

    @Override
    @NonNull
    public InputStream openRead() throws IOException {
        try {
            return this.mutable.openRead();
        }
        catch (IOException savedEX) {
            for (FSBackend fsb : this.parents) {
                try {
                    return fsb.openRead();
                }
                catch (IOException iOException) {
                }
            }
            throw savedEX;
        }
    }

    @Override
    @NonNull
    public OutputStream openWrite() throws IOException {
        if (this.parent != null && this.parent.getState() instanceof FSBackend.DirectoryState) {
            this.parent.mkdirs();
        }
        return this.mutable.openWrite();
    }

    @Override
    public void changeTime(long time) {
        this.mutable.changeTime(time);
    }

    @Override
    public boolean delete() {
        return this.mutable.delete();
    }
}

