/*
 * Decompiled with CFR 0.152.
 */
package gabien.uslx.vfs.impl;

import gabien.uslx.vfs.FSBackend;
import gabien.uslx.vfs.impl.UnixPathModel;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class RAMFSBackend
extends FSBackend {
    public final VFSDir vfsRoot;
    public final String myName;

    public RAMFSBackend() {
        super(null, UnixPathModel.INSTANCE, true);
        this.vfsRoot = new VFSDir();
        this.myName = "";
    }

    private RAMFSBackend(@NonNull RAMFSBackend parent, String myName) {
        super(parent, UnixPathModel.INSTANCE, true);
        this.vfsRoot = parent.vfsRoot;
        this.myName = myName;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof RAMFSBackend) {
            RAMFSBackend r = (RAMFSBackend)obj;
            if (r.vfsRoot != this.vfsRoot) {
                return false;
            }
            if (r.parent == null != (this.parent == null)) {
                return false;
            }
            if (r.parent != null && !r.parent.equals(this.parent)) {
                return false;
            }
            return r.myName.equals(this.myName);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return (this.parent != null ? this.parent.hashCode() : 0) ^ this.myName.hashCode();
    }

    public String toString() {
        return "ram:" + this.getAbsolutePath();
    }

    @Nullable
    public VFSNode getParentVFSNode() {
        if (this.parent == null) {
            return null;
        }
        return ((RAMFSBackend)this.parent).getVFSNode();
    }

    @Nullable
    public VFSNode getVFSNode() {
        if (this.parent == null) {
            return this.vfsRoot;
        }
        VFSNode parentVFSNode = ((RAMFSBackend)this.parent).getVFSNode();
        if (parentVFSNode == null) {
            return null;
        }
        return parentVFSNode.descend(this.myName);
    }

    @Override
    public void changeTime(long time) {
    }

    @Override
    public boolean delete() {
        VFSNode vn = this.getParentVFSNode();
        if (vn instanceof VFSDir) {
            VFSDir vd = (VFSDir)vn;
            VFSNode me = vd.contents.get(this.myName);
            if (me == null) {
                return false;
            }
            if (!me.isDeletable()) {
                return false;
            }
            return vd.contents.remove(this.myName) != null;
        }
        return false;
    }

    @Override
    public String getAbsolutePath() {
        if (this.parent == null) {
            return "/";
        }
        if (this.parent.parent == null) {
            return this.parent.getAbsolutePath() + this.myName;
        }
        return this.parent.getAbsolutePath() + "/" + this.myName;
    }

    @Override
    @Nullable
    public FSBackend.XState getState() {
        VFSNode vn = this.getVFSNode();
        return vn != null ? vn.toState() : null;
    }

    @Override
    @NonNull
    public FSBackend intoInner(String dirName) {
        if (dirName.equals("..")) {
            return this.parentOrRoot;
        }
        return new RAMFSBackend(this, dirName);
    }

    @Override
    public boolean mkdir() {
        VFSNode parent = this.getParentVFSNode();
        if (parent == null) {
            return false;
        }
        if (!(parent instanceof VFSDir)) {
            return false;
        }
        VFSDir pd = (VFSDir)parent;
        VFSNode existing = pd.contents.get(this.myName);
        if (existing instanceof VFSDir) {
            return true;
        }
        if (existing == null) {
            pd.contents.put(this.myName, new VFSDir());
            return true;
        }
        return false;
    }

    @Override
    @NonNull
    public InputStream openRead() throws IOException {
        VFSNode vn = this.getVFSNode();
        if (!(vn instanceof VFSFile)) {
            throw new FileNotFoundException(this.getAbsolutePath());
        }
        return new ByteArrayInputStream(((VFSFile)vn).contents.toByteArray());
    }

    @Override
    @NonNull
    public OutputStream openWrite() throws IOException {
        VFSNode parent = this.getParentVFSNode();
        if (parent == null) {
            throw new FileNotFoundException(this.getAbsolutePath());
        }
        if (!(parent instanceof VFSDir)) {
            throw new FileNotFoundException(this.getAbsolutePath());
        }
        VFSDir pd = (VFSDir)parent;
        VFSNode existing = pd.contents.get(this.myName);
        if (existing instanceof VFSFile || existing == null) {
            VFSFile vf = new VFSFile();
            pd.contents.put(this.myName, vf);
            return vf.contents;
        }
        throw new FileNotFoundException(this.getAbsolutePath());
    }

    public static class VFSFile
    extends VFSNode {
        public final ByteArrayOutputStream contents = new ByteArrayOutputStream();

        @Override
        @Nullable
        public VFSNode descend(String value) {
            return null;
        }

        @Override
        public boolean isDeletable() {
            return true;
        }

        @Override
        public FSBackend.XState toState() {
            return new FSBackend.FileState(this.contents.size());
        }
    }

    public static class VFSDir
    extends VFSNode {
        public final HashMap<String, VFSNode> contents = new HashMap();

        @Override
        @Nullable
        public VFSNode descend(String value) {
            return this.contents.get(value);
        }

        @Override
        public boolean isDeletable() {
            return this.contents.isEmpty();
        }

        @Override
        public FSBackend.XState toState() {
            return new FSBackend.DirectoryState(this.contents.keySet().toArray(new String[0]));
        }
    }

    public static abstract class VFSNode {
        @Nullable
        public abstract VFSNode descend(String var1);

        public abstract boolean isDeletable();

        public abstract FSBackend.XState toState();
    }
}

