/*
 * Decompiled with CFR 0.152.
 */
package gabien.uslx.vfs.impl;

import gabien.uslx.vfs.FSBackend;
import gabien.uslx.vfs.PathModel;
import gabien.uslx.vfs.impl.UnixPathModel;
import gabien.uslx.vfs.impl.WindowsPathModel;
import gabien.uslx.vfs.impl.WindowsRootJavaIOFSBackend;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class JavaIOFSBackend
extends FSBackend {
    public static final FSBackend ROOT = !System.getProperty("os.name").toLowerCase().contains("windows") ? new JavaIOFSBackend(UnixPathModel.INSTANCE, null, new File("/")) : WindowsRootJavaIOFSBackend.INSTANCE;
    @NonNull
    public final File file;

    private static File attemptCanonicalize(File f) {
        try {
            return f.getCanonicalFile();
        }
        catch (Exception ex) {
            return f;
        }
    }

    public static FSBackend from(File f) {
        return JavaIOFSBackend.from(f, null, null);
    }

    public static FSBackend from(File f, @Nullable JavaIOFSBackend reuseHint1, @Nullable JavaIOFSBackend reuseHint2) {
        f = JavaIOFSBackend.attemptCanonicalize(f);
        if (reuseHint1 != null && f.equals(reuseHint1.file)) {
            return reuseHint1;
        }
        if (reuseHint2 != null && f.equals(reuseHint2.file)) {
            return reuseHint2;
        }
        File fParentFile = f.getParentFile();
        if (fParentFile == null) {
            if (ROOT instanceof WindowsRootJavaIOFSBackend) {
                return new JavaIOFSBackend(WindowsPathModel.INSTANCE, ROOT, f);
            }
            return ROOT;
        }
        FSBackend parent = JavaIOFSBackend.from(fParentFile, reuseHint1, reuseHint2);
        return new JavaIOFSBackend(parent.pathModel, parent, f);
    }

    private JavaIOFSBackend(@NonNull PathModel pm, @Nullable FSBackend parent, @NonNull File f) {
        super(parent, pm, false);
        this.file = f;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof JavaIOFSBackend) {
            return ((JavaIOFSBackend)obj).file.equals(this.file);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.file.hashCode();
    }

    @Override
    public FSBackend intoInner(String dirName) {
        JavaIOFSBackend potentialReuseHint = null;
        if (this.parent instanceof JavaIOFSBackend) {
            potentialReuseHint = (JavaIOFSBackend)this.parent;
        }
        return JavaIOFSBackend.from(new File(this.file, dirName), this, potentialReuseHint);
    }

    public String toString() {
        return "real:" + this.file;
    }

    @Override
    public FSBackend.XState getState() {
        if (!this.file.exists()) {
            return null;
        }
        if (this.file.isDirectory()) {
            File[] list = this.file.listFiles();
            if (list == null) {
                System.err.println("File that is a directory but isn't listable: " + this.file + " (probably an access error)");
                return new FSBackend.DirectoryState(new String[0]);
            }
            String[] ents = new String[list.length];
            for (int i = 0; i < ents.length; ++i) {
                ents[i] = list[i].getName();
            }
            return new FSBackend.DirectoryState(ents);
        }
        return new FSBackend.FileTimeState(this.file.length(), this.file.lastModified());
    }

    @Override
    @NonNull
    public InputStream openRead() throws IOException {
        return new FileInputStream(this.file);
    }

    @Override
    @NonNull
    public OutputStream openWrite() throws IOException {
        return new FileOutputStream(this.file);
    }

    @Override
    public boolean delete() {
        return this.file.delete();
    }

    @Override
    public boolean mkdir() {
        return this.file.mkdir() || this.file.isDirectory();
    }

    @Override
    public void changeTime(long time) {
        this.file.setLastModified(time);
    }

    @Override
    public String getAbsolutePath() {
        return this.file.getAbsolutePath();
    }
}

