/*
 * Decompiled with CFR 0.152.
 */
package gabien.uslx.vfs.impl;

import gabien.uslx.vfs.PathModel;
import java.io.IOException;

public class DodgyInputWorkaroundPathModel
extends PathModel {
    public final PathModel base;

    public DodgyInputWorkaroundPathModel(PathModel pm) {
        this.base = pm;
    }

    @Override
    public String estimatePathComponentFolding(String a) {
        return a.toLowerCase();
    }

    @Override
    public boolean estimatePathComponentEquality(String a, String b) {
        return a.equalsIgnoreCase(b);
    }

    @Override
    public boolean verifyPathComponent(boolean isFirstAbsComponent, String dirName) {
        if (dirName.contains("\\")) {
            return false;
        }
        if (dirName.contains("\u00a5")) {
            return false;
        }
        if (dirName.contains("\u20a9")) {
            return false;
        }
        return this.base.verifyPathComponent(isFirstAbsComponent, dirName);
    }

    public String adjustSlashes(String anyPath) {
        return anyPath.replace('\\', '/').replace('\u00a5', '/').replace('\u20a9', '/');
    }

    @Override
    public String nameOf(String anyPath) {
        return this.base.nameOf(this.adjustSlashes(anyPath));
    }

    @Override
    public String[] relPathToComponents(String absolutePath) throws IOException {
        return this.base.relPathToComponents(this.adjustSlashes(absolutePath));
    }

    @Override
    public String[] absPathToComponents(String absolutePath) throws IOException {
        return this.base.absPathToComponents(this.adjustSlashes(absolutePath));
    }
}

