/*
 * Decompiled with CFR 0.152.
 */
package gabien.uslx.vfs.impl;

import gabien.uslx.vfs.FSBackend;
import gabien.uslx.vfs.PathModel;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class AttachedFSBackend
extends FSBackend {
    public final String attachmentName;
    public final FSBackend attachment;

    public AttachedFSBackend(FSBackend target, String name, boolean usesRootPathLogic) {
        this(target.pathModel, target, name, usesRootPathLogic);
    }

    public AttachedFSBackend(PathModel pm, FSBackend target, String name, boolean usesRootPathLogic) {
        super(null, pm, usesRootPathLogic);
        this.attachment = target;
        this.attachmentName = name;
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this;
    }

    @Override
    public int hashCode() {
        return 0;
    }

    @Override
    @NonNull
    protected FSBackend intoInner(String dirName) {
        if (this.pathModel.estimatePathComponentEquality(dirName, this.attachmentName)) {
            return this.attachment;
        }
        return new FSBackend.Null(this.pathModel, this.parent, dirName, false);
    }

    @Override
    public String getAbsolutePath() {
        return "/";
    }

    @Override
    public boolean mkdir() {
        return true;
    }

    @Override
    @Nullable
    public FSBackend.XState getState() {
        return new FSBackend.DirectoryState(new String[]{this.attachmentName});
    }

    @Override
    @NonNull
    public InputStream openRead() throws IOException {
        throw new IOException("You cannot read this");
    }

    @Override
    @NonNull
    public OutputStream openWrite() throws IOException {
        throw new IOException("You cannot write this");
    }

    @Override
    public void changeTime(long time) {
    }

    @Override
    public boolean delete() {
        return false;
    }
}

