/*
 * Decompiled with CFR 0.152.
 */
package gabien.uslx.vfs;

import gabien.uslx.vfs.PathModel;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class FSBackend {
    @NonNull
    public final FSBackend root;
    @Nullable
    public final FSBackend parent;
    @NonNull
    public final FSBackend parentOrRoot;
    @NonNull
    public final PathModel pathModel;
    public final boolean usesRootPathLogic;

    public FSBackend(@Nullable FSBackend parent, @NonNull PathModel pathModel, boolean rpl) {
        this.root = parent != null ? parent.root : this;
        this.parent = parent;
        this.parentOrRoot = parent == null ? this.root : parent;
        this.pathModel = pathModel;
        this.usesRootPathLogic = rpl;
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    @NonNull
    public final FSBackend into(String dirName) {
        if (dirName.equals(".")) {
            return this;
        }
        if (!this.pathModel.verifyPathComponent(this.usesRootPathLogic, dirName)) {
            return new InvalidPath(this.pathModel, this, dirName);
        }
        return this.intoInner(dirName);
    }

    @NonNull
    public final FSBackend into(String ... dirNames) {
        FSBackend res = this;
        for (String s : dirNames) {
            res = res.into(s);
        }
        return res;
    }

    @NonNull
    protected abstract FSBackend intoInner(String var1);

    @NonNull
    public final FSBackend intoPath(String path) {
        FSBackend fsb = this.intoRelPath(path);
        if (fsb instanceof InvalidPath) {
            fsb = this.intoAbsPath(path);
        }
        return fsb;
    }

    @NonNull
    public final FSBackend intoRelPath(String path) {
        FSBackend res = this;
        try {
            for (String s : this.pathModel.relPathToComponents(path)) {
                res = res.intoInner(s);
            }
        }
        catch (IOException ioe) {
            return new InvalidPath(this.pathModel, this, path);
        }
        return res;
    }

    @NonNull
    public final FSBackend intoAbsPath(String path) {
        FSBackend res = this.root;
        try {
            for (String s : this.pathModel.absPathToComponents(path)) {
                res = res.intoInner(s);
            }
        }
        catch (IOException ioe) {
            return new InvalidPath(this.pathModel, this.root, path);
        }
        return res;
    }

    public abstract String getAbsolutePath();

    public abstract boolean mkdir();

    public final void mkdirs() {
        if (this.parent != null) {
            this.parent.mkdirs();
        }
        this.mkdir();
    }

    public final FSBackend parentMkdirs() {
        if (this.parent != null) {
            this.parent.mkdirs();
        }
        return this;
    }

    @Nullable
    public abstract XState getState();

    public final boolean isDirectory() {
        return this.getState() instanceof DirectoryState;
    }

    public final boolean exists() {
        return this.getState() != null;
    }

    @NonNull
    public abstract InputStream openRead() throws IOException;

    @NonNull
    public ByteBuffer mapOrRead() throws IOException {
        int am;
        InputStream inp = this.openRead();
        try {
            if (inp instanceof FileInputStream) {
                FileInputStream fis = (FileInputStream)inp;
                FileChannel fc = fis.getChannel();
                MappedByteBuffer mbb = fc.map(FileChannel.MapMode.PRIVATE, 0L, fc.size());
                fis.close();
                return mbb;
            }
        }
        catch (Exception fis) {
            // empty catch block
        }
        ByteArrayOutputStream tmp = new ByteArrayOutputStream();
        byte[] tmp2 = new byte[256];
        while ((am = inp.read(tmp2)) >= 0) {
            tmp.write(tmp2, 0, am);
        }
        return ByteBuffer.wrap(tmp.toByteArray());
    }

    @NonNull
    public abstract OutputStream openWrite() throws IOException;

    public abstract void changeTime(long var1);

    public abstract boolean delete();

    public static class InvalidPath
    extends Null {
        public InvalidPath(PathModel pathModel, FSBackend parent, String path) {
            super(pathModel, parent, path, false);
        }

        @Override
        public Null makeDownLevel(String name) {
            return new InvalidPath(this.pathModel, this, name);
        }
    }

    public static class Null
    extends FSBackend {
        public final String myName;

        public Null(PathModel pathModel, FSBackend parent, String myName, boolean rpl) {
            super(parent, pathModel, rpl);
            this.myName = myName;
        }

        public Null makeDownLevel(String name) {
            return new Null(this.pathModel, this, name, false);
        }

        @Override
        public boolean equals(Object obj) {
            return obj == this;
        }

        @Override
        public int hashCode() {
            return 0;
        }

        public String toString() {
            return "invalid:" + this.getAbsolutePath();
        }

        @Override
        public String getAbsolutePath() {
            return this.parent.getAbsolutePath() + "/" + this.myName;
        }

        @Override
        @NonNull
        public FSBackend intoInner(String dirName) {
            if (dirName.equals("..")) {
                return this.parentOrRoot;
            }
            return this.makeDownLevel(dirName);
        }

        @Override
        public boolean mkdir() {
            return false;
        }

        @Override
        @Nullable
        public XState getState() {
            return null;
        }

        @Override
        @NonNull
        public InputStream openRead() throws IOException {
            throw new IOException("Invalid access: " + this.getAbsolutePath());
        }

        @Override
        @NonNull
        public OutputStream openWrite() throws IOException {
            throw new IOException("Invalid access: " + this.getAbsolutePath());
        }

        @Override
        public void changeTime(long time) {
        }

        @Override
        public boolean delete() {
            return false;
        }
    }

    public static class DirectoryState
    extends XState {
        public final String[] entries;

        public DirectoryState(String[] ents) {
            this.entries = ents;
        }
    }

    public static class FileTimeState
    extends FileState {
        public final long time;

        public FileTimeState(long s, long t) {
            super(s);
            this.time = t;
        }
    }

    public static class FileState
    extends XState {
        public final long size;

        public FileState(long s) {
            this.size = s;
        }
    }

    public static class XState {
    }
}

