/*
 * Decompiled with CFR 0.152.
 */
package gabien.uslx.licensing;

import gabien.uslx.licensing.LicenseComponent;
import java.util.HashSet;
import java.util.LinkedList;

public enum LicenseManager {
    I;

    private final HashSet<LicenseComponent> components = new HashSet();

    private LicenseManager() {
        this.register(LicenseComponent.LC_GABIEN);
    }

    public synchronized void register(LicenseComponent a) {
        this.components.add(a);
    }

    public synchronized void dependency(LicenseComponent x, LicenseComponent y) {
        if (y.dependencies.contains(x)) {
            throw new RuntimeException("Dependency loop: " + x.name + " x " + y.name);
        }
        x.dependencies.add(y);
        y.dependents.add(x);
        for (LicenseComponent z : x.dependents) {
            z.dependencies.add(y);
            y.dependents.add(z);
        }
    }

    public synchronized HashSet<LicenseComponent> getLicenseComponents() {
        return new HashSet<LicenseComponent>(this.components);
    }

    public LinkedList<LicenseComponent> getSortedLicenseComponents() {
        LinkedList<LicenseComponent> ll = new LinkedList<LicenseComponent>();
        HashSet<LicenseComponent> seen = new HashSet<LicenseComponent>();
        HashSet<LicenseComponent> pass = new HashSet<LicenseComponent>();
        for (LicenseComponent lc : this.getLicenseComponents()) {
            if (lc.dependents.size() != 0) continue;
            pass.add(lc);
        }
        while (pass.size() > 0) {
            HashSet<LicenseComponent> thisPass = pass;
            pass = new HashSet();
            for (LicenseComponent lc : thisPass) {
                if (seen.contains(lc)) continue;
                seen.add(lc);
                ll.add(lc);
                pass.addAll(lc.dependencies);
            }
        }
        return ll;
    }
}

