/*
 * Decompiled with CFR 0.152.
 */
package gabien.uslx.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class HexByteEncoding {
    public static String toHexString(int v) {
        String res = Integer.toHexString(v &= 0xFF);
        if (res.length() == 1) {
            return "0" + res;
        }
        return res;
    }

    public static String toHexString(int ... vals) {
        StringBuilder sb = new StringBuilder();
        for (int v : vals) {
            sb.append(HexByteEncoding.toHexString(v));
        }
        return sb.toString();
    }

    public static String toHexString(byte[] vals, int offset, int length) {
        StringBuilder sb = new StringBuilder();
        while (length > 0) {
            sb.append(HexByteEncoding.toHexString((int)vals[offset++]));
            --length;
        }
        return sb.toString();
    }

    public static byte[] fromHexString(String string) {
        char[] ca = string.toCharArray();
        return HexByteEncoding.fromHexString(ca, 0, ca.length);
    }

    public static byte[] fromHexString(char[] charArray, int offset, int length) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            HexByteEncoding.fromHexString(charArray, offset, length, baos);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        return baos.toByteArray();
    }

    public static void fromHexString(char[] charArray, int offset, int length, OutputStream out) throws IOException {
        int existing = -1;
        while (length > 0) {
            char c;
            int digit;
            if ((digit = HexByteEncoding.decodeHexDigit(c = charArray[offset++])) != -1) {
                if (existing != -1) {
                    int b = existing << 4 | digit;
                    out.write(b);
                    existing = -1;
                } else {
                    existing = digit;
                }
            }
            --length;
        }
    }

    public static int decodeHexDigit(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        return -1;
    }
}

