/*
 * Decompiled with CFR 0.152.
 */
package gabien.uslx.io;

import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;

public interface DataOutputEx
extends DataOutput {
    @Override
    default public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    default public void writeBoolean(boolean v) throws IOException {
        this.write(v ? 1 : 0);
    }

    @Override
    default public void writeByte(int v) throws IOException {
        this.write(v);
    }

    @Override
    default public void writeBytes(String s) throws IOException {
        int l = s.length();
        for (int i = 0; i < l; ++i) {
            this.write(s.charAt(i) & 0xFF);
        }
    }

    @Override
    default public void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    @Override
    default public void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    @Override
    default public void writeChar(int v) throws IOException {
        this.writeShort(v);
    }

    @Override
    default public void writeChars(String s) throws IOException {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            this.writeShort(s.charAt(i));
        }
    }

    @Override
    default public void writeUTF(String s) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        dos.writeUTF(s);
        byte[] ba = baos.toByteArray();
        this.writeShort(ba.length - 2);
        this.write(ba, 2, ba.length - 2);
    }
}

