/*
 * Decompiled with CFR 0.152.
 */
package gabien.uslx.io;

import java.io.DataInput;
import java.io.IOException;

public interface DataInputEx
extends DataInput {
    default public String readFourCC() throws IOException {
        char a = (char)this.readUnsignedByte();
        char b = (char)this.readUnsignedByte();
        char c = (char)this.readUnsignedByte();
        char d = (char)this.readUnsignedByte();
        return new String(new char[]{a, b, c, d});
    }

    @Override
    default public boolean readBoolean() throws IOException {
        return this.readUnsignedByte() != 0;
    }

    @Override
    default public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    default public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    default public short readShort() throws IOException {
        return (short)this.readUnsignedShort();
    }

    @Override
    default public char readChar() throws IOException {
        return (char)this.readUnsignedShort();
    }

    @Override
    default public String readLine() throws IOException {
        StringBuilder sb = new StringBuilder();
        while (true) {
            int b;
            if ((b = this.readUnsignedByte()) == 13) {
                continue;
            }
            if (b == 10) break;
            sb.append((char)b);
        }
        return sb.toString();
    }

    @Override
    default public String readUTF() throws IOException {
        StringBuilder sb = new StringBuilder();
        int r = this.readUnsignedShort();
        while (r > 0) {
            int b = this.readUnsignedByte();
            if (b < 128) {
                sb.append((char)b);
                --r;
                continue;
            }
            if (b >= 224) {
                int c = this.readUnsignedByte();
                int d = this.readUnsignedByte();
                int res = (b & 0xF) << 12 | (c & 0x3F) << 6 | d & 0x3F;
                sb.append((char)res);
                r -= 3;
                continue;
            }
            if (b >= 192) {
                int d = this.readUnsignedByte();
                int res = (b & 0x1F) << 6 | d & 0x3F;
                sb.append((char)res);
                r -= 2;
                continue;
            }
            throw new IOException("invalid MUTF-8");
        }
        return sb.toString();
    }
}

